/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.core.runtime.CoreException;

public class OperatorCast
extends CompoundInstruction {
    private final IASTCastExpression castExpr;
    private IType castType;

    public OperatorCast(int start, IASTCastExpression castExpr) {
        super(start);
        this.castExpr = castExpr;
    }

    @Override
    public void execute() throws CoreException {
        Number origValue;
        OperandValue value = this.fInterpreter.pop();
        if (value.getStringValue() != null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorCast_CannotCastString);
        }
        this.castType = this.getCastType(this.fInterpreter.getTypeEngine());
        IVariableLocation location = value.getValueLocation();
        OperandValue castValue = new OperandValue(this.castType);
        Number castedValue = origValue = value.getValue();
        if (this.castType instanceof ICPPBasicType) {
            ICPPBasicType cppType = (ICPPBasicType)this.castType;
            if (cppType.getBaseType() == 2 || cppType.getBaseType() == 3 || cppType.getBaseType() == 7 || cppType.getBaseType() == 6) {
                switch (cppType.getByteSize()) {
                    case 1: {
                        if (cppType.isSigned()) {
                            castedValue = origValue.byteValue();
                            break;
                        }
                        castedValue = origValue.byteValue() & 0xFF;
                        break;
                    }
                    case 2: {
                        if (cppType.isSigned()) {
                            castedValue = origValue.shortValue();
                            break;
                        }
                        castedValue = origValue.shortValue() & 0xFFFFF;
                        break;
                    }
                    case 4: {
                        if (cppType.isSigned()) {
                            castedValue = origValue.intValue();
                            break;
                        }
                        castedValue = (long)origValue.intValue() & 0xFFFFFFFFL;
                        break;
                    }
                    case 8: {
                        if (cppType.isSigned()) {
                            castedValue = BigInteger.valueOf(origValue.longValue());
                            break;
                        }
                        castedValue = BigInteger.valueOf(origValue.longValue()).and(Mask8Bytes);
                    }
                }
            } else if (cppType.getBaseType() == 4 || cppType.getBaseType() == 5) {
                switch (cppType.getByteSize()) {
                    case 4: {
                        castedValue = Float.valueOf(origValue.longValue());
                        break;
                    }
                    case 8: 
                    case 12: {
                        castedValue = (double)origValue.longValue();
                    }
                }
            }
        }
        castValue.setValue(castedValue);
        castValue.setValueLocation(location);
        this.fInterpreter.push(castValue);
    }

    public IType getCastType(TypeEngine typeEngine) throws CoreException {
        if (this.castType == null) {
            IASTTypeId typeId = this.castExpr.getTypeId();
            this.castType = typeEngine.getTypeForTypeId(typeId);
        }
        return this.castType;
    }

    public IASTCastExpression getCastExpr() {
        return this.castExpr;
    }
}

