/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.ValueVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfMessages;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.IFrameRegisters;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.core.runtime.CoreException;

public class DwarfFrameRegisters
implements IFrameRegisters {
    private final EDCServicesTracker tracker;
    private final Stack.StackFrameDMC context;
    private final IFrameRegisters childRegisters;
    private Map<Integer, Object> cachedRegisters = new TreeMap<Integer, Object>();
    private final DwarfFrameRegisterProvider.FrameDescriptionEntry fde;
    private final DwarfDebugInfoProvider provider;
    private Map<Integer, DwarfFrameRegisterProvider.AbstractRule> frameRegisterRules;
    private DwarfFrameRegisterProvider.InstructionState state;

    public DwarfFrameRegisters(EDCServicesTracker tracker, Stack.StackFrameDMC context, DwarfFrameRegisterProvider.FrameDescriptionEntry fde, IFrameRegisters childRegisters, DwarfDebugInfoProvider provider) {
        if (childRegisters == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
        this.tracker = tracker;
        this.context = context;
        this.fde = fde;
        this.childRegisters = childRegisters;
    }

    @Override
    public BigInteger getRegister(int regnum, int bytes) throws CoreException {
        BigInteger value = null;
        CoreException exception = null;
        Object object = this.cachedRegisters.get(regnum);
        if (object == null) {
            try {
                IVariableLocation loc = this.getRegisterLocation(regnum);
                if (loc == null) {
                    throw EDCDebugger.newCoreException(MessageFormat.format(DwarfMessages.DwarfFrameRegisters_CannotReadRegister, regnum, this.context.getInstructionPtrAddress().toHexAddressString()));
                }
                value = loc.readValue(bytes);
                this.cachedRegisters.put(regnum, value);
            }
            catch (CoreException e) {
                exception = e;
                this.cachedRegisters.put(regnum, (Object)exception);
            }
        } else if (object instanceof CoreException) {
            exception = (CoreException)((Object)object);
        } else {
            value = (BigInteger)object;
        }
        if (exception != null) {
            throw exception;
        }
        return value;
    }

    private IVariableLocation getRegisterLocation(int regnum) throws CoreException {
        DwarfFrameRegisterProvider.AbstractRule rule;
        if (this.frameRegisterRules == null) {
            this.state = new DwarfFrameRegisterProvider.InstructionState(this.tracker, this.context, this.childRegisters, this.fde);
            this.frameRegisterRules = this.calculateFrameRegisterRules(this.state);
        }
        if ((rule = this.frameRegisterRules.get(regnum)) == null) {
            if (this.fde.getCIE().version < 3) {
                if (regnum == this.state.getCFARegister()) {
                    return new ValueVariableLocation(this.state.readCFA());
                }
                return new ValueVariableLocation(this.childRegisters.getRegister(regnum, this.fde.addressSize));
            }
            return null;
        }
        return rule.evaluate(this.state);
    }

    private Map<Integer, DwarfFrameRegisterProvider.AbstractRule> calculateFrameRegisterRules(DwarfFrameRegisterProvider.InstructionState state) throws CoreException {
        if (this.fde.getCIE() == null) {
            throw EDCDebugger.newCoreException(MessageFormat.format(DwarfMessages.DwarfFrameRegisters_NoCommonInfoEntry, this.fde));
        }
        List<DwarfFrameRegisterProvider.AbstractInstruction> initialLocationInstructions = this.fde.getCIE().getInitialLocations(this.provider);
        for (DwarfFrameRegisterProvider.AbstractInstruction instr : initialLocationInstructions) {
            instr.applyInstruction(state);
        }
        TreeMap<IRangeList.Entry, List<DwarfFrameRegisterProvider.AbstractInstruction>> fdeInstrs = this.fde.getInstructions(this.provider);
        long currentPC = this.context.getModule().toLinkAddress(this.context.getInstructionPtrAddress()).getValue().longValue();
        for (Map.Entry<IRangeList.Entry, List<DwarfFrameRegisterProvider.AbstractInstruction>> instrEntry : fdeInstrs.entrySet()) {
            IRangeList.Entry entry = instrEntry.getKey();
            if (entry.low > currentPC) break;
            try {
                for (DwarfFrameRegisterProvider.AbstractInstruction instr : instrEntry.getValue()) {
                    instr.applyInstruction(state);
                }
            }
            catch (Exception e) {
                throw EDCDebugger.newCoreException(DwarfMessages.DwarfFrameRegisters_ErrorCalculatingLocation, e);
            }
        }
        return state.regRules;
    }

    @Override
    public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
        CoreException exception = null;
        try {
            IVariableLocation loc = this.getRegisterLocation(regnum);
            if (loc == null) {
                throw EDCDebugger.newCoreException(MessageFormat.format(DwarfMessages.DwarfFrameRegisters_CannotWriteRegister, regnum, this.context.getInstructionPtrAddress().toHexAddressString()));
            }
            loc.writeValue(bytes, value);
            this.cachedRegisters.put(regnum, value);
        }
        catch (CoreException e) {
            exception = e;
            this.cachedRegisters.put(regnum, (Object)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

