/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.symbols;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemTypeId;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.PushLongOrBigInteger;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.CPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.PointerType;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.SymbolsMessages;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.core.runtime.CoreException;

public class TypeEngine {
    private Map<Integer, Integer> typeSizeMap;
    private Map<Object, IType> typeMap = new HashMap<Object, IType>();
    private int addressSize;
    private Map<IType, String> typeNameMap = new HashMap<IType, String>();
    private final IDebugInfoProvider debugInfoProvider;
    private Map<String, Object> typeIdToTypeMap = new HashMap<String, Object>();
    private Map<String, IArrayType> typeToArrayTypeMap = new HashMap<String, IArrayType>();
    private boolean charIsSigned;

    public TypeEngine(ITargetEnvironment targetEnvironment, IDebugInfoProvider debugInfoProvider) {
        this.debugInfoProvider = debugInfoProvider;
        if (targetEnvironment != null) {
            this.typeSizeMap = targetEnvironment.getBasicTypeSizes();
            this.addressSize = targetEnvironment.getPointerSize();
            this.charIsSigned = targetEnvironment.isCharSigned();
        } else {
            this.typeSizeMap = Collections.emptyMap();
            this.addressSize = 4;
            this.charIsSigned = true;
        }
    }

    public IType getIntegerTypeOfSize(int size, boolean isSigned) {
        int flags;
        int basicType;
        if (isSigned && this.typeSizeMap.get(1) == size) {
            basicType = 2;
            flags = 4;
        } else if (!isSigned && this.typeSizeMap.get(1) == size) {
            basicType = 2;
            flags = 8;
        } else if (isSigned && this.typeSizeMap.get(4) == size) {
            basicType = 3;
            flags = 6;
        } else if (!isSigned && this.typeSizeMap.get(4) == size) {
            basicType = 3;
            flags = 10;
        } else if (isSigned && this.typeSizeMap.get(6) == size) {
            basicType = 3;
            flags = 4;
        } else if (!isSigned && this.typeSizeMap.get(6) == size) {
            basicType = 3;
            flags = 8;
        } else if (isSigned && this.typeSizeMap.get(8) == size) {
            basicType = 3;
            flags = 5;
        } else if (!isSigned && this.typeSizeMap.get(8) == size) {
            basicType = 3;
            flags = 9;
        } else if (isSigned && this.typeSizeMap.get(10) == size) {
            basicType = 3;
            flags = 68;
        } else if (!isSigned && this.typeSizeMap.get(10) == size) {
            basicType = 3;
            flags = 72;
        } else {
            return null;
        }
        return this.getBasicType(basicType, flags, size);
    }

    public IType getIntegerTypeFor(int typeUtilsBasicType, boolean isSigned) {
        return this.getIntegerTypeOfSize(this.typeSizeMap.get(typeUtilsBasicType), isSigned);
    }

    public IType getBasicType(int basicType, int flags, int size) {
        return this.getBasicType(null, basicType, flags, size);
    }

    public IType getBasicType(String name, int basicType, int flags, int size) {
        IType type;
        Object typeCode = (flags << 16) + (basicType << 8) + size;
        if (name != null) {
            typeCode = String.valueOf(name) + ":" + typeCode;
        }
        if ((type = this.typeMap.get(typeCode)) == null) {
            if (name == null) {
                name = this.getBasicTypeName(basicType, flags);
            }
            type = new CPPBasicType(name, basicType, flags, size);
            this.typeMap.put(typeCode, type);
        }
        return type;
    }

    private String getBasicTypeName(int basicType, int flags) {
        String name;
        switch (basicType) {
            case 6: {
                name = "bool";
                break;
            }
            case 7: {
                name = "wchar_t";
                break;
            }
            case 2: {
                name = "char";
                break;
            }
            case 3: {
                if ((flags & 2) != 0) {
                    name = "short";
                    break;
                }
                if ((flags & 1) != 0) {
                    name = "long";
                    break;
                }
                if ((flags & 0x40) != 0) {
                    name = "long long";
                    break;
                }
                name = "int";
                break;
            }
            case 4: {
                name = "float";
                break;
            }
            case 5: {
                if ((flags & 1) != 0) {
                    name = "long double";
                    break;
                }
                name = "double";
                break;
            }
            case 0: {
                name = "<<unknown>>";
                break;
            }
            case 1: {
                name = "void";
                break;
            }
            default: {
                assert (false);
                name = "";
            }
        }
        if ((flags & 4) != 0) {
            name = "signed " + name;
        } else if ((flags & 8) != 0) {
            name = "unsigned " + name;
        }
        if ((flags & 0x10) != 0) {
            name = "complex " + name;
        }
        if ((flags & 0x20) != 0) {
            name = "imaginary " + name;
        }
        return name;
    }

    public IType getFloatTypeOfSize(int size) {
        if (this.typeSizeMap.get(12) == size) {
            return this.getBasicType(4, 0, size);
        }
        if (this.typeSizeMap.get(14) == size) {
            return this.getBasicType(5, 0, size);
        }
        if (this.typeSizeMap.get(16) == size) {
            return this.getBasicType(5, 1, size);
        }
        return null;
    }

    public IType getCharacterType(int size) {
        if (this.typeSizeMap.get(1) == size) {
            return this.getBasicType(2, 0, size);
        }
        return this.getBasicType(7, 0, size);
    }

    public IType getWideCharacterType(int size) {
        return this.getBasicType(7, 0, size);
    }

    public IType getBooleanType(int size) {
        return this.getBasicType(6, 0, size);
    }

    public IType getCharArrayType(IType charType, int length) {
        ArrayBoundType bounds = new ArrayBoundType(null, length);
        ArrayType array = new ArrayType(String.valueOf(charType.getName()) + "[" + length + "]", null, length, null);
        array.addBound(bounds);
        array.setType(charType);
        return array;
    }

    public IType getPointerSizeType() {
        int size = this.getPointerSize();
        return this.getBasicType("ptrsize_t", 3, 0, size);
    }

    private int getPointerSize() {
        return this.addressSize;
    }

    public int getTypeSize(int basicType) {
        Integer size = this.typeSizeMap.get(basicType);
        return size != null ? size : 0;
    }

    public String getTypeName(IType valueType) {
        if (valueType == null) {
            return "";
        }
        String typeName = this.typeNameMap.get(valueType);
        if (typeName == null) {
            typeName = TypeUtils.getFullTypeName(valueType);
            this.typeNameMap.put(valueType, typeName);
        }
        return typeName;
    }

    public IType getTypeForTypeId(IASTTypeId typeId) throws CoreException {
        if (typeId == null) {
            throw EDCDebugger.newCoreException(SymbolsMessages.TypeEngine_NoTypeToCast);
        }
        if (typeId instanceof IASTProblemTypeId) {
            throw EDCDebugger.newCoreException(((IASTProblemTypeId)typeId).getProblem().getMessage());
        }
        String typeSignature = ASTSignatureUtil.getSignature((IASTTypeId)typeId);
        Object obj = this.typeIdToTypeMap.get(typeSignature);
        if (obj instanceof CoreException) {
            throw (CoreException)((Object)obj);
        }
        obj = null;
        IType type = null;
        if (!(obj instanceof IType)) {
            try {
                type = this.createTypeForTypeId(typeId, typeSignature, type);
                this.typeIdToTypeMap.put(typeSignature, type);
            }
            catch (CoreException e) {
                this.typeIdToTypeMap.put(typeSignature, (Object)e);
                throw e;
            }
        } else {
            type = (IType)obj;
        }
        return type;
    }

    private IType createTypeForTypeId(IASTTypeId typeId, String typeSignature, IType type) throws CoreException {
        Object aMatch;
        int elaboration;
        IASTDeclSpecifier declSpec = typeId.getDeclSpecifier();
        if (declSpec instanceof IASTSimpleDeclSpecifier) {
            type = this.getTypeForDeclSpecifier((IASTSimpleDeclSpecifier)declSpec);
        } else if (declSpec instanceof IASTNamedTypeSpecifier || declSpec instanceof IASTElaboratedTypeSpecifier) {
            String typeName;
            elaboration = -1;
            if (declSpec instanceof IASTNamedTypeSpecifier) {
                typeName = ((IASTNamedTypeSpecifier)declSpec).getName().toString();
            } else {
                elaboration = ((IASTElaboratedTypeSpecifier)declSpec).getKind();
                typeName = ((IASTElaboratedTypeSpecifier)declSpec).getName().toString();
            }
            if (this.debugInfoProvider != null) {
                aMatch = null;
                Collection<IType> types = this.debugInfoProvider.getTypesByName(typeName);
                for (IType aType : types) {
                    aMatch = aType;
                    if (elaboration >= 0 && (!(type instanceof ICompositeType) || ((ICompositeType)type).getKey() != elaboration)) continue;
                    type = aType;
                    break;
                }
                if (type == null && aMatch != null) {
                    type = aMatch;
                }
            }
        }
        if (type == null) {
            throw EDCDebugger.newCoreException(String.valueOf(SymbolsMessages.TypeEngine_CannotResolveType) + typeSignature);
        }
        if (typeId.getAbstractDeclarator() instanceof ICPPASTDeclarator) {
            ICPPASTDeclarator declarator = (ICPPASTDeclarator)typeId.getAbstractDeclarator();
            aMatch = declarator.getPointerOperators();
            int types = ((IASTPointerOperator[])aMatch).length;
            elaboration = 0;
            while (elaboration < types) {
                PointerType ptr = new PointerType(String.valueOf(type.getName()) + "*", type.getScope(), this.getPointerSize(), null);
                ptr.setType((IType)type);
                type = ptr;
                ++elaboration;
            }
            if (declarator instanceof ICPPASTArrayDeclarator) {
                ICPPASTArrayDeclarator arrayDeclarator = (ICPPASTArrayDeclarator)declarator;
                ArrayType arrayType = new ArrayType(String.valueOf(type.getName()) + "[]", type.getScope(), 0, null);
                IASTArrayModifier[] iASTArrayModifierArray = arrayDeclarator.getArrayModifiers();
                int n = iASTArrayModifierArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTArrayModifier arrayMod = iASTArrayModifierArray[n2];
                    long elementCount = 1L;
                    if (arrayMod.getConstantExpression() != null) {
                        elementCount = this.getConstantValue(arrayMod.getConstantExpression());
                    }
                    ArrayBoundType bound = new ArrayBoundType(arrayType.getScope(), elementCount);
                    arrayType.addBound(bound);
                    ++n2;
                }
                arrayType.setType((IType)type);
                type = arrayType;
            }
        }
        return type;
    }

    private long getConstantValue(IASTExpression constantExpression) throws CoreException {
        if (constantExpression instanceof IASTLiteralExpression && ((IASTLiteralExpression)constantExpression).getKind() == 0) {
            PushLongOrBigInteger pusher = new PushLongOrBigInteger(constantExpression.toString());
            return pusher.getLong();
        }
        throw EDCDebugger.newCoreException(String.valueOf(SymbolsMessages.TypeEngine_ExpectedIntegerConstant) + ASTSignatureUtil.getExpressionString((IASTExpression)constantExpression));
    }

    private IType getTypeForDeclSpecifier(IASTSimpleDeclSpecifier simpleDeclSpec) throws CoreException {
        int baseType = 0;
        int basicType = 0;
        switch (simpleDeclSpec.getType()) {
            case 6: {
                baseType = 6;
                basicType = 18;
                break;
            }
            case 2: {
                baseType = 2;
                basicType = 1;
                break;
            }
            case 7: {
                baseType = 7;
                basicType = 20;
                break;
            }
            case 5: {
                baseType = 5;
                basicType = 14;
                break;
            }
            case 4: {
                baseType = 4;
                basicType = 12;
                break;
            }
            case 3: {
                baseType = 3;
                basicType = 6;
                break;
            }
            case 1: {
                baseType = 1;
                break;
            }
            case 8: 
            case 9: {
                throw EDCDebugger.newCoreException(SymbolsMessages.TypeEngine_NoDecltypeSupport);
            }
            case 0: {
                baseType = 3;
                break;
            }
            default: {
                throw EDCDebugger.newCoreException(String.valueOf(SymbolsMessages.TypeEngine_UnhandledType) + simpleDeclSpec);
            }
        }
        int flags = 0;
        if (simpleDeclSpec.isComplex()) {
            flags |= 0x10;
        }
        if (simpleDeclSpec.isImaginary()) {
            flags |= 0x20;
        }
        if (simpleDeclSpec.isLong()) {
            flags |= 1;
            if (basicType == 0) {
                basicType = 8;
            }
        }
        if (simpleDeclSpec.isLongLong()) {
            flags |= 0x40;
            if (basicType == 0) {
                basicType = 10;
            }
        }
        if (simpleDeclSpec.isShort()) {
            flags |= 2;
            if (basicType == 0) {
                basicType = 4;
            }
        }
        if (simpleDeclSpec.isUnsigned()) {
            flags |= 8;
        }
        if (simpleDeclSpec.isSigned()) {
            flags |= 4;
        }
        if (!simpleDeclSpec.isUnsigned() && !simpleDeclSpec.isSigned()) {
            if (baseType == 2) {
                flags |= this.charIsSigned ? 4 : 8;
            } else if (baseType == 3) {
                flags |= 4;
            }
        }
        int size = this.getTypeSize(basicType);
        return this.getBasicType(baseType, flags, size);
    }

    public IType convertToArrayType(IType type, int count) throws CoreException {
        String typeSig = this.getTypeName(type);
        IArrayType arrayType = this.typeToArrayTypeMap.get(typeSig);
        if (arrayType == null) {
            IType baseType = type = TypeUtils.getStrippedType(type);
            if (type instanceof IPointerType || type instanceof IArrayType) {
                baseType = type.getType();
            }
            if (baseType == null) {
                throw EDCDebugger.newCoreException(String.valueOf(SymbolsMessages.TypeEngine_CannotResolveBaseType) + typeSig);
            }
            arrayType = new ArrayType(String.valueOf(baseType.getName()) + "[]", baseType.getScope(), baseType.getByteSize() * count, null);
            ArrayBoundType bound = new ArrayBoundType(arrayType.getScope(), count);
            arrayType.addBound(bound);
            arrayType.setType(baseType);
            this.typeToArrayTypeMap.put(typeSig, arrayType);
        }
        return arrayType;
    }
}

