/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.tizen.dynamicanalyzer.util.InternalLogger;

public class Logger {
    private static InternalLogger instance;
    private static boolean isLogOn;

    static {
        isLogOn = true;
    }

    public static void init(int logLevel) {
        instance = InternalLogger.getInstance();
        instance.setLogLevel(logLevel);
    }

    public static void setLogToFile(String filePath, String fileName) throws Exception {
        String logFilePath = instance.getLogPath(filePath, fileName);
        if (logFilePath == null) {
            return;
        }
        File logFile = new File(logFilePath);
        FileOutputStream fos = new FileOutputStream(logFile);
        MultiOutput multiSysOut = new MultiOutput(System.out, fos);
        MultiOutput multiSysErr = new MultiOutput(System.err, fos);
        PrintStream out = new PrintStream(multiSysOut);
        PrintStream err = new PrintStream(multiSysErr);
        System.setOut(out);
        System.setErr(err);
    }

    public static void error(Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(0)) {
            return;
        }
        instance.printLog(true, 0, logMessage);
    }

    public static void error(String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(0)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(true, 0, msg);
    }

    public static void error() {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(0)) {
            return;
        }
        instance.printLog();
    }

    public static void warning(Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(1)) {
            return;
        }
        instance.printLog(true, 1, logMessage);
    }

    public static void warning(boolean applyNewLine, Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(1)) {
            return;
        }
        instance.printLog(applyNewLine, 1, logMessage);
    }

    public static void warning(String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(1)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(true, 1, msg);
    }

    public static void warning(boolean applyNewLine, String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(1)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(applyNewLine, 1, msg);
    }

    public static void warning() {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(1)) {
            return;
        }
        instance.printLog();
    }

    public static void info(Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(2)) {
            return;
        }
        instance.printLog(true, 2, logMessage);
    }

    public static void info(boolean applyNewLine, Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(2)) {
            return;
        }
        instance.printLog(applyNewLine, 2, logMessage);
    }

    public static void info(String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(2)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(true, 2, msg);
    }

    public static void info(boolean applyNewLine, String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(2)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(applyNewLine, 2, msg);
    }

    public static void info() {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(2)) {
            return;
        }
        instance.printLog();
    }

    public static void check(Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(3)) {
            return;
        }
        instance.printLog(true, 3, logMessage);
    }

    public static void check(boolean applyNewLine, Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(3)) {
            return;
        }
        instance.printLog(applyNewLine, 3, logMessage);
    }

    public static void check(String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(3)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(true, 3, msg);
    }

    public static void check(boolean applyNewLine, String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(3)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(applyNewLine, 3, msg);
    }

    public static void check() {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(3)) {
            return;
        }
        instance.printLog();
    }

    public static void debug(Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(4)) {
            return;
        }
        instance.printLog(true, 4, logMessage);
    }

    public static void debug(boolean applyNewLine, Object logMessage) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(4)) {
            return;
        }
        instance.printLog(applyNewLine, 4, logMessage);
    }

    public static void debug(String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(4)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(true, 4, msg);
    }

    public static void debug(boolean applyNewLine, String format, Object ... args) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(4)) {
            return;
        }
        String msg = String.format(format, args);
        instance.printLog(applyNewLine, 4, msg);
    }

    public static void debug() {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(4)) {
            return;
        }
        instance.printLog();
    }

    public static void exception(Throwable e) {
        if (!isLogOn) {
            return;
        }
        instance.printLog(true, 0, e);
    }

    public static void performanceStart(String folderPath, String savefileName, String key) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(5)) {
            return;
        }
        instance.performanceStart(folderPath, savefileName, key);
    }

    public static void performance(String key, String testStep, String description) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(5)) {
            return;
        }
        String msg = instance.performanceNormal(key, description);
        if (msg == null) {
            return;
        }
        instance.printLog(true, 5, instance.makeTestLog(testStep, msg));
    }

    public static void performanceEnd(String key) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(5)) {
            return;
        }
        instance.performanceEnd(key);
    }

    public static void performanceSubThreadStart(String key, String testStep, String description) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(5)) {
            return;
        }
        instance.performanceSubThreadStart(description);
    }

    public static void performanceSubThreadEnd(String key, String testStep, String description) {
        if (!isLogOn) {
            return;
        }
        if (!instance.checkLevel(5)) {
            return;
        }
        String msg = instance.performanceSubThreadEnd(key, testStep, description);
        if (msg == null) {
            return;
        }
        instance.printLog(true, 5, instance.makeTestLog(testStep, msg));
    }

    public static void setLogOn(boolean flag) {
        isLogOn = flag;
    }

    private static class MultiOutput
    extends OutputStream {
        OutputStream[] outputStreams;

        public MultiOutput(OutputStream ... outputStreams) {
            this.outputStreams = outputStreams;
        }

        @Override
        public void write(int b) throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream out = outputStreamArray[n2];
                out.write(b);
                ++n2;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream out = outputStreamArray[n2];
                out.write(b);
                ++n2;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream out = outputStreamArray[n2];
                out.write(b, off, len);
                ++n2;
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream out = outputStreamArray[n2];
                out.flush();
                ++n2;
            }
        }

        @Override
        public void close() throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream out = outputStreamArray[n2];
                out.close();
                ++n2;
            }
        }
    }
}

