/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressDialog;
import org.tizen.dynamicanalyzer.widgets.progress.CircleProgress;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class ProgressManager {
    public static ProgressManager INSTANCE;
    private static final int DELAY = 100;
    private ProgressDialog dialog;
    List<ProgressHolder> progresses = new ArrayList<ProgressHolder>();
    private volatile boolean backgroundOnly = true;

    private ProgressManager(Shell parent, Composite base) {
        this.dialog = new ProgressDialog(parent, base);
    }

    public static synchronized ProgressManager createProgressManager(Shell parent, Composite base) {
        if (INSTANCE == null) {
            INSTANCE = new ProgressManager(parent, base);
        }
        return INSTANCE;
    }

    public ProgressHolder createProgress(boolean runInBackground, int progressStyle, String upperText, String bottomText, SelectionListener cancelListener) {
        this.backgroundOnly = this.backgroundOnly && runInBackground;
        ProgressHolder progress = new ProgressHolder(progressStyle, upperText, bottomText, cancelListener);
        this.progresses.add(progress);
        Display.getDefault().syncExec(this.dialog::draw);
        return progress;
    }

    public void stopProgress(ProgressHolder progress) {
        this.progresses.remove(progress);
        Display.getDefault().asyncExec(progress::dispose);
        if (this.progresses.isEmpty()) {
            Display.getDefault().asyncExec(this.dialog::close);
            this.backgroundOnly = true;
        } else {
            Display.getDefault().syncExec(this.dialog::draw);
        }
    }

    public void updateValue() {
        block7: {
            int v = 0;
            for (ProgressHolder p : this.progresses) {
                v += p.getValue();
            }
            CircleProgress.getCircleProgress().setValue(v /= this.progresses.size());
            if (v == 100) {
                try {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Logger.error((Object)e);
                        Thread.currentThread().interrupt();
                        Display.getDefault().asyncExec(() -> {
                            CircleProgress.getCircleProgress().setVisible(false);
                            CircleProgress.getCircleProgress().setValue(0);
                            this.dialog.close();
                        });
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Display.getDefault().asyncExec(() -> {
                        CircleProgress.getCircleProgress().setVisible(false);
                        CircleProgress.getCircleProgress().setValue(0);
                        this.dialog.close();
                    });
                    throw throwable;
                }
                Display.getDefault().asyncExec(() -> {
                    CircleProgress.getCircleProgress().setVisible(false);
                    CircleProgress.getCircleProgress().setValue(0);
                    this.dialog.close();
                });
            }
        }
    }

    public String getUpperString() {
        if (this.progresses.size() == 1) {
            return this.progresses.get(0).getUpperText();
        }
        return this.dialog.headerText;
    }

    public boolean isBackgroundOnly() {
        return this.backgroundOnly;
    }

    public void setBackgroundOnly(boolean b) {
        this.backgroundOnly = b;
        this.dialog.setBackgroundOnly(b);
    }
}

