/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.progress;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class BarProgress
extends Canvas {
    Color barStartColor = ColorResources.POINT;
    Color barEndColor = ColorResources.POINT;
    private int value = 0;

    public BarProgress(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this::drawBar);
    }

    public void setValue(int value) {
        if (value < 0 || value > 100) {
            return;
        }
        this.value = value;
        if (!ProgressManager.INSTANCE.isBackgroundOnly()) {
            Display.getDefault().syncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.redraw();
                this.update();
            });
        }
    }

    public void drawBar(PaintEvent e) {
        Canvas canvas = (Canvas)e.widget;
        Rectangle rect = canvas.getBounds();
        e.gc.setForeground(ProgressHolder.barStartBgColor);
        e.gc.setBackground(ProgressHolder.barEndBgColor);
        e.gc.fillGradientRectangle(0, 0, rect.width, rect.height, true);
        int width = this.value * rect.width / 100;
        e.gc.setForeground(this.barStartColor);
        e.gc.setBackground(this.barEndColor);
        e.gc.fillGradientRectangle(0, 0, width, rect.height, true);
        e.gc.setForeground(ProgressHolder.barOutlineColor);
        e.gc.drawRectangle(new Rectangle(0, 0, rect.width - 1, rect.height - 1));
        Point widgetSize = this.getSize();
        String text = String.valueOf(this.value) + "%";
        if (ProgressHolder.percentageFont != null) {
            e.gc.setFont(ProgressHolder.percentageFont);
        }
        if (ProgressHolder.fontColor != null) {
            e.gc.setForeground(ProgressHolder.fontColor);
        }
        Point textSize = e.gc.stringExtent(text);
        e.gc.drawString(text, (widgetSize.x - textSize.x) / 2, (widgetSize.y - textSize.y) / 2 + 1, true);
    }
}

