/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class AppStartupDBTable
extends DBTable {
    public static final String TABLE_NAME = "APP_STARTUP";
    private static final String SELECT_QUERY = " where pid = %s";

    public AppStartupDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.STAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.STAGE_ID.index + 1, (Integer)rowData.get(COLUMN.STAGE_ID.index));
                prep.setLong(COLUMN.START_TIME.index + 1, (Long)rowData.get(COLUMN.START_TIME.index));
                prep.setLong(COLUMN.END_TIME.index + 1, (Long)rowData.get(COLUMN.END_TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getLong(4));
            row.add(rs.getLong(5));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public List<List<Object>> getAppStartupFromDB() {
        return this.selectAllColumnData(null);
    }

    public List<List<Object>> getObjectDataFromDB(int selectedPid) {
        ArrayList<String> selectColumn = new ArrayList<String>();
        selectColumn.add(COLUMN.SEQUENCE_NUMBER.name);
        selectColumn.add(COLUMN.PID.name);
        selectColumn.add(COLUMN.STAGE_ID.name);
        selectColumn.add(COLUMN.START_TIME.name);
        selectColumn.add(COLUMN.END_TIME.name);
        String where = null;
        if (selectedPid != 0) {
            where = String.format(SELECT_QUERY, selectedPid);
        }
        return this.selectData(selectColumn, where, this);
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        STAGE_ID(2, "STAGE_ID"),
        START_TIME(3, "START_TIME"),
        END_TIME(4, "END_TIME");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum STAGE {
        LIBRARY_MAPPING(0, "library mapping"),
        MAIN(1, "main"),
        CREATE(2, "create"),
        SERVICE(3, "service");

        private final int id;
        private final String name;

        private STAGE(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static String getName(int id) {
            if (LIBRARY_MAPPING.getID() == id) {
                return LIBRARY_MAPPING.getName();
            }
            if (MAIN.getID() == id) {
                return MAIN.getName();
            }
            if (CREATE.getID() == id) {
                return CREATE.getName();
            }
            if (SERVICE.getID() == id) {
                return SERVICE.getName();
            }
            return "";
        }
    }
}

