/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebCallTraceTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallTraceView
extends DAViewComposite {
    Composite contents = null;
    private StackLayout stackLayout;
    private CallTraceTable nativeTable = null;
    private WebCallTraceTable webTable = null;

    public CallTraceView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(TimelinePageLabels.CALL_TRACE_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.nativeTable = new CallTraceTable(this.contents, 0, 68354);
        this.nativeTable.setTableName(TimelinePageLabels.CALL_TRACE_VIEW_TITLE);
        this.webTable = new WebCallTraceTable(this.contents, 0, 68354);
        Project currentProject = Global.getProject();
        if (currentProject == null) {
            this.stackLayout.topControl = this.nativeTable;
        } else {
            this.changeTable(currentProject.isWebApplication());
        }
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            if (this.stackLayout.topControl == this.nativeTable) {
                this.nativeTable.setSelectionByTime(start, end);
            } else {
                this.webTable.setSelectionByTime(start, end);
            }
            this.updateView();
        }
    }

    public void changeTable(boolean isWeb) {
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.contents.layout();
    }

    public void updateView() {
        ((DATableComposite)this.stackLayout.topControl).updateTable();
    }

    public void clear() {
        ((DATableComposite)this.stackLayout.topControl).clear();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }
}

