/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.IStorableCdtVariables;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.EclipseVariablesVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariable;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableCdtVariables
implements IStorableCdtVariables {
    public static final String MACROS_ELEMENT_NAME = "macros";
    private HashMap<String, ICdtVariable> fMacros;
    private boolean fIsDirty = false;
    private boolean fIsChanged = false;
    private boolean fIsReadOnly;

    private HashMap<String, ICdtVariable> getMap() {
        if (this.fMacros == null) {
            this.fMacros = new HashMap();
        }
        return this.fMacros;
    }

    public StorableCdtVariables(boolean readOnly) {
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(StorableCdtVariables base, boolean readOnly) {
        this.fMacros = (HashMap)base.getMap().clone();
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(ICdtVariable[] vars, boolean readOnly) {
        this.fMacros = new HashMap(vars.length);
        ICdtVariable[] iCdtVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            ICdtVariable var = iCdtVariableArray[n2];
            this.addMacro(var);
            ++n2;
        }
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(ICStorageElement element, boolean readOnly) {
        this.load(element);
        this.fIsReadOnly = readOnly;
    }

    private void load(ICStorageElement element) {
        ICStorageElement[] nodeList = element.getChildren();
        int i = 0;
        while (i < nodeList.length) {
            ICStorageElement node = nodeList[i];
            String name = node.getName();
            if ("stringMacro".equals(name)) {
                this.addMacro(new StorableCdtVariable(node));
            } else if ("stringListMacro".equals(name)) {
                this.addMacro(new StorableCdtVariable(node));
            }
            ++i;
        }
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(ICStorageElement element) {
        if (this.fMacros != null) {
            for (ICdtVariable v : this.fMacros.values()) {
                StorableCdtVariable macro = (StorableCdtVariable)v;
                ICStorageElement macroEl = CdtVariableResolver.isStringListVariable(macro.getValueType()) ? element.createChild("stringListMacro") : element.createChild("stringMacro");
                macro.serialize(macroEl);
            }
        }
        this.fIsDirty = false;
    }

    private void addMacro(ICdtVariable macro) {
        String name = macro.getName();
        if (name == null) {
            return;
        }
        this.getMap().put(name, macro);
    }

    @Override
    public ICdtVariable createMacro(String name, int type, String value) {
        if (name == null || "".equals(name = name.trim()) || CdtVariableResolver.isStringListVariable(type)) {
            return null;
        }
        ICdtVariable macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableCdtVariable(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public ICdtVariable checkMacro(String name, int type, String value) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ICdtVariable macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getValueType() == type) {
            try {
                String val = macro.getStringValue();
                if (val != null && val.equals(value) || val == value) {
                    return macro;
                }
            }
            catch (CdtVariableException cdtVariableException) {}
        }
        return null;
    }

    public ICdtVariable checkMacro(String name, int type, String[] value) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ICdtVariable macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getValueType() == type) {
            try {
                String[] val = macro.getStringListValue();
                if (val != null) {
                    if (value != null && value.length == val.length) {
                        int i = 0;
                        while (i < val.length) {
                            if (!value[i].equals(val[i])) break;
                            ++i;
                        }
                        if (i == value.length) {
                            return macro;
                        }
                    }
                } else if (value == val) {
                    return macro;
                }
            }
            catch (CdtVariableException cdtVariableException) {}
        }
        return null;
    }

    public void setMacros(ICdtVariable[] macros) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (macros == null || macros.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                for (ICdtVariable m : this.getMap().values()) {
                    int i = 0;
                    while (i < macros.length) {
                        if (m.getName().equals(macros[i].getName())) break;
                        ++i;
                    }
                    if (i != macros.length) continue;
                    this.deleteMacro(m.getName());
                }
            }
            this.createMacros(macros);
        }
    }

    @Override
    public void createMacros(ICdtVariable[] macros) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ICdtVariable[] iCdtVariableArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            ICdtVariable macro = iCdtVariableArray[n2];
            this.createMacro(macro);
            ++n2;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fMacros == null || this.fMacros.isEmpty();
    }

    @Override
    public ICdtVariable createMacro(ICdtVariable copy) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        String name = copy.getName();
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        int type = copy.getValueType();
        ICdtVariable macro = null;
        try {
            if (CdtVariableResolver.isStringListVariable(type)) {
                String[] value = copy.getStringListValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableCdtVariable(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            } else {
                String value = copy.getStringValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableCdtVariable(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            }
        }
        catch (CdtVariableException cdtVariableException) {}
        return macro;
    }

    @Override
    public ICdtVariable createMacro(String name, int type, String[] value) {
        if (name == null || "".equals(name = name.trim()) || !CdtVariableResolver.isStringListVariable(type)) {
            return null;
        }
        ICdtVariable macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableCdtVariable(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    @Override
    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        this.fIsChanged = changed;
    }

    @Override
    public ICdtVariable getMacro(String name) {
        int indx;
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        ICdtVariable var = this.getMap().get(name);
        if (var == null && (indx = name.indexOf(58)) != -1) {
            String baseName = name.substring(0, indx);
            ICdtVariable tmp = this.getMap().get(baseName);
            if (tmp != null && CdtVariableManager.getDefault().toEclipseVariable(tmp, null) != null) {
                var = EclipseVariablesVariableSupplier.getInstance().getVariable(name);
            }
        }
        return var;
    }

    @Override
    public ICdtVariable[] getMacros() {
        Collection<ICdtVariable> macros = this.getMap().values();
        return macros.toArray(new ICdtVariable[macros.size()]);
    }

    @Override
    public ICdtVariable deleteMacro(String name) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        ICdtVariable macro = this.getMap().remove(name);
        if (macro != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    @Override
    public boolean deleteAll() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        HashMap<String, ICdtVariable> map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ICdtVariable var) {
        ICdtVariable curVar = this.getMacro(var.getName());
        if (curVar == null) {
            return false;
        }
        return new UserDefinedVariableSupplier.VarKey(curVar, false).equals(new UserDefinedVariableSupplier.VarKey(var, false));
    }
}

