/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRequestMonitor<V extends RequestMonitor>
extends RequestMonitor {
    private List<V> fRequestMonitorList = Collections.synchronizedList(new LinkedList());
    private Map<V, Boolean> fStatusMap = Collections.synchronizedMap(new HashMap());
    private int fDoneCounter;
    private boolean fRequiresDoneAdding;
    private boolean fDoneAdding;

    public MultiRequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        super(executor, parentRequestMonitor);
        this.setStatus((IStatus)new MultiStatus("org.eclipse.cdt.dsf", 0, "Collective status for set of sub-operations.", null));
    }

    public synchronized <T extends V> T add(T rm) {
        assert (!this.fStatusMap.containsKey(rm));
        if (this.fDoneAdding) {
            throw new IllegalStateException("Can't add a monitor after having called doneAdding()");
        }
        this.fRequestMonitorList.add(rm);
        this.fStatusMap.put((Boolean)rm, false);
        ++this.fDoneCounter;
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMonitorDone(V requestMonitor) {
        boolean callSuperDone = false;
        MultiRequestMonitor multiRequestMonitor = this;
        synchronized (multiRequestMonitor) {
            if (this.getStatus() instanceof MultiStatus) {
                ((MultiStatus)this.getStatus()).merge(((RequestMonitor)requestMonitor).getStatus());
            }
            if (!this.fStatusMap.containsKey(requestMonitor)) {
                throw new IllegalArgumentException("Unknown monitor.");
            }
            this.fStatusMap.put((Boolean)requestMonitor, true);
            assert (this.fDoneCounter > 0);
            --this.fDoneCounter;
            if (this.fDoneCounter == 0 && (this.fDoneAdding || !this.fRequiresDoneAdding)) {
                assert (!this.fStatusMap.containsValue(false));
                callSuperDone = true;
            }
        }
        if (callSuperDone) {
            super.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> getRequestMonitors() {
        List<V> list = this.fRequestMonitorList;
        synchronized (list) {
            return new LinkedList<V>(this.fRequestMonitorList);
        }
    }

    public boolean isRequestMonitorDone(V rm) {
        return this.fStatusMap.get(rm);
    }

    public void requireDoneAdding() {
        this.fRequiresDoneAdding = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneAdding() {
        boolean callSuperDone = false;
        MultiRequestMonitor multiRequestMonitor = this;
        synchronized (multiRequestMonitor) {
            if (!this.fRequiresDoneAdding) {
                throw new IllegalStateException("The method requiresDoneAdding() must be called first");
            }
            this.fDoneAdding = true;
            if (this.fDoneCounter == 0) {
                assert (!this.fStatusMap.containsValue(false));
                callSuperDone = true;
            }
        }
        if (callSuperDone) {
            super.done();
        }
    }

    @Override
    public String toString() {
        return "Multi-RequestMonitor: " + this.getStatus().toString();
    }
}

