/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.internal.StructuredTextDelimsEsc;

public class StructuredTextEmail
extends StructuredTextDelimsEsc {
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;

    public StructuredTextEmail() {
        super("<>.:,;@");
    }

    public int getDirection(IStructuredTextExpert expert, String text) {
        return this.getDirection(expert, text, new StructuredTextCharTypes(expert, text));
    }

    public int getDirection(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes) {
        String language = expert.getEnvironment().getLanguage();
        if (!language.equals("ar")) {
            return 0;
        }
        int domainStart = text.indexOf(64);
        if (domainStart < 0) {
            domainStart = 0;
        }
        int i = domainStart;
        while (i < text.length()) {
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 2 || charType == 1) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int getSpecialsCount(IStructuredTextExpert expert) {
        return 2;
    }

    protected String getDelimiters() {
        return "()\"\"";
    }
}

