/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.tizen.dynamicanalyzer.collection.IndexedHashMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.DeviceStatusInfo;
import org.tizen.dynamicanalyzer.project.FunctionInfo;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.ProjectVersion;
import org.tizen.dynamicanalyzer.project.data.BinaryInfoDBTable;
import org.tizen.dynamicanalyzer.project.data.FunctionNameDBTable;
import org.tizen.dynamicanalyzer.project.data.MemoryMapDBTable;
import org.tizen.dynamicanalyzer.project.data.ProcessInfoDBTable;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.StringUtil;

public class Project {
    private static final ProcessInfoDBTable processInfoTable = new ProcessInfoDBTable();
    private static final MemoryMapDBTable memoryMapTable = new MemoryMapDBTable();
    private static final BinaryInfoDBTable binaryInfoTable = new BinaryInfoDBTable();
    private static final FunctionNameDBTable functionNameTable = new FunctionNameDBTable();
    private static final String QUERY_TABLE_ROW_COUNT = "select table_name, cardinality from information_schema.system_tablestats where table_schema='PUBLIC' order by table_name";
    private static final String TABLE_FOR_FILE_PAGE = "FILE_API";
    private static final String TABLE_FOR_THREAD_PAGE = "THREAD_DATA";
    private static final String TABLE_FOR_NETWORK_PAGE = "NETWORK_API";
    private static final String TABLE_FOR_OPENGL_PAGE = "GL_API";
    private static final String TABLE_FOR_SCREENSHOT_CHART = "TIMELINE_SCREENSHOT";
    private static final String TABLE_FOR_UIEVENT_CHART = "TIMELINE_UIEVENT";
    private static final int MAX_FILENAME_LENGTH = 50;
    private static final String DEFAULT_TIME_FORMAT = "_yyyy-MM-dd-HH-mm-ss";
    private static final String SECTION_F = "[";
    private static final String SECTION_E = "]";
    private static final String PRIMITIVE_SECTION = "[Primitive]";
    private static final String DEVICE_SECTION = "[Device Information]";
    private static final String APP_SECTION = "[Application information]";
    private static final String VERSION = "version";
    private static final String PROTOCOL_VERSION = "protocolVersion";
    private static final String DEVICE = "device";
    private static final String PACKAGEID = "packageID";
    private static final String APPNAME = "appName";
    private static final String CREATE_TIME = "createTime";
    private static final String TOTAL_STOP_TIME = "totalStopTime";
    private static final String REPLAY_STOP_TIME = "replayStopTime";
    private static final String PROFILE_START_TIME = "profilingStartTime";
    private static final String PAGE_TAB_LIST = "pageTabList";
    private static final String TIMELINE_CHART_LIST = "timelineChartList";
    private static final String LSAN_PREFERENCE = "lsanPreference";
    private static final String MEMPS_DATA_AVAILABLE = "availableMemps";
    private static final String DA_START_TIME = "daStartTime";
    private ProjectVersion version = ProjectVersion.VERSION_UNKNOWN;
    private String protocolVersion = null;
    private String device = null;
    private String packageID = null;
    private String appID = null;
    private String createTime = null;
    private long totalStopTime = -1L;
    private long replayStopTime = -1L;
    private DATime profilingStartTime = null;
    private String savePath = null;
    private Map<Integer, ProcessInformation> processInfos = new HashMap<Integer, ProcessInformation>();
    private IndexedHashMap<String, FunctionInfo> functionInfos = new IndexedHashMap();
    private DeviceStatusInfo targetDeviceStatusInfo = null;
    private AppInfo targetApplicationInfo = null;
    private final Object profilingStartTime_lock = new Object();
    private NavigableMap<Long, ImageInfo> imageInfos = new TreeMap<Long, ImageInfo>();
    private String[] pageTabList = null;
    private String[] timelineChartList = null;
    private int seqRotation = 0;
    private int activeProcessCount = 0;
    private boolean availableMemps = false;
    private String daStartTime = "";
    private boolean isLoadedData = false;
    private boolean isSaved = false;

    public static Project getProjectFromFile(String savedPath) {
        BufferedReader in;
        Project project;
        block5: {
            project = new Project();
            project.setSavePath(savedPath);
            in = project.getOpenReader(savedPath);
            if (in != null) {
                try {
                    String fail = project.openPrimitive(in);
                    if (fail == null) break block5;
                    Logger.error((Object)("Failed to open project " + savedPath + ": can not read " + fail + " information"));
                }
                catch (IOException e) {
                    try {
                        Logger.exception((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    return null;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                return null;
            }
            return null;
        }
        CommonUtil.tryClose((Object[])new Object[]{in});
        return project;
    }

    public ProjectVersion getVersion() {
        return this.version;
    }

    public void setVersion(ProjectVersion version) {
        this.version = version;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getPackageID() {
        return this.packageID;
    }

    public void setPackageID(String packageID) {
        this.packageID = packageID;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public long getTotalStopTime() {
        return this.totalStopTime;
    }

    public void setTotalStopTime(long totalStopTime) {
        this.totalStopTime = totalStopTime;
    }

    public long getReplayStopTime() {
        return this.replayStopTime;
    }

    public void setReplayStopTime(long replayStopTime) {
        this.replayStopTime = replayStopTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATime getProfilingStartTime() {
        Object object = this.profilingStartTime_lock;
        synchronized (object) {
            return this.profilingStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfilingStartTime(DATime profilingStartTime) {
        Object object = this.profilingStartTime_lock;
        synchronized (object) {
            this.profilingStartTime = profilingStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndSetProfilingStartTime(DATime startTime) {
        Object object = this.profilingStartTime_lock;
        synchronized (object) {
            if (this.profilingStartTime == null) {
                this.profilingStartTime = startTime;
            }
        }
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public int getSeqRotation() {
        return this.seqRotation;
    }

    public void incSeqRotation() {
        ++this.seqRotation;
    }

    public int getActiveProcessCount() {
        return this.activeProcessCount;
    }

    public void incActiveProcessCount() {
        ++this.activeProcessCount;
    }

    public void decActiveProcessCount() {
        --this.activeProcessCount;
    }

    public ProcessInformation getProcessInformation(int pid) {
        return this.processInfos.get(pid);
    }

    public void putProcessInformation(ProcessInformation pinfo) {
        if (pinfo != null) {
            int pid = pinfo.getPid();
            if (this.processInfos.size() == 0) {
                pinfo.setMainOrNot(true);
            }
            this.processInfos.put(pid, pinfo);
        }
    }

    public int getTotalFunctionEntryCount() {
        int sum = 0;
        for (Map.Entry<Integer, ProcessInformation> entry : this.processInfos.entrySet()) {
            sum += entry.getValue().getFunctionEntryLogCount();
        }
        return sum;
    }

    public int[] getProcessIDs() {
        int processcount = this.processInfos.size();
        int[] pids = new int[processcount];
        int index = 0;
        for (Map.Entry<Integer, ProcessInformation> entry : this.processInfos.entrySet()) {
            pids[index++] = entry.getValue().getPid();
        }
        return pids;
    }

    public DeviceStatusInfo getDeviceStatusInfo() {
        return this.targetDeviceStatusInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceStatusInfo(DeviceStatusInfo statusInfo) {
        Map<Integer, String> apiNameMap;
        this.targetDeviceStatusInfo = statusInfo;
        if (this.targetDeviceStatusInfo != null && (apiNameMap = this.targetDeviceStatusInfo.getApiNameMap()) != null) {
            ArrayList<String> keylist = new ArrayList<String>();
            ArrayList<FunctionInfo> valuelist = new ArrayList<FunctionInfo>();
            int maxindex = -1;
            for (Map.Entry<Integer, String> entry : apiNameMap.entrySet()) {
                int index = entry.getKey();
                String apiName = entry.getValue();
                FunctionInfo fninfo = new FunctionInfo(apiName);
                fninfo.setID(index);
                keylist.add(apiName);
                valuelist.add(fninfo);
                if (maxindex >= index) continue;
                maxindex = index;
            }
            IndexedHashMap<String, FunctionInfo> indexedHashMap = this.functionInfos;
            synchronized (indexedHashMap) {
                if (!this.functionInfos.buildFrom(keylist, valuelist, maxindex)) {
                    Logger.error((Object)"failed to build function info map");
                }
            }
        }
    }

    public AppInfo getApplicationInfo() {
        return this.targetApplicationInfo;
    }

    public void setApplicationInfo(AppInfo appInfo) {
        this.targetApplicationInfo = appInfo;
    }

    public String getFunctionName(int id) {
        FunctionInfo finfo = this.functionInfos.getByIndex(id);
        if (finfo == null) {
            return "Unknown API";
        }
        return finfo.getFunctionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFunctionID(String name) {
        FunctionInfo finfo = this.functionInfos.getByKey(name);
        if (finfo == null) {
            finfo = new FunctionInfo(name);
            IndexedHashMap<String, FunctionInfo> indexedHashMap = this.functionInfos;
            synchronized (indexedHashMap) {
                this.functionInfos.put(name, finfo);
            }
        }
        return finfo.getID();
    }

    public void addImageInfo(ImageInfo info) {
        if (info != null) {
            long time = info.getTime();
            this.imageInfos.put(time, info);
        }
    }

    public ImageInfo getLeastImageInfoByTime(long time) {
        Map.Entry<Long, ImageInfo> entry = this.imageInfos.ceilingEntry(time);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public ImageInfo getGreatestImageInfoByTime(long time) {
        Map.Entry<Long, ImageInfo> entry = this.imageInfos.floorEntry(time);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public ImageInfo getNextImageInfo(ImageInfo info) {
        if (info == null) {
            if (!this.imageInfos.isEmpty()) {
                return this.imageInfos.firstEntry().getValue();
            }
            return null;
        }
        Map.Entry<Long, ImageInfo> entry = this.imageInfos.higherEntry(info.getTime());
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public ImageInfo getPrevImageInfo(ImageInfo info) {
        if (info == null) {
            return null;
        }
        Map.Entry<Long, ImageInfo> entry = this.imageInfos.lowerEntry(info.getTime());
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Set<Map.Entry<Long, ImageInfo>> getImageInfoSet() {
        return Collections.unmodifiableSet(this.imageInfos.entrySet());
    }

    public void buildImageInfoFrom(List<ImageInfo> imageList) {
        this.imageInfos.clear();
        int imgsize = imageList.size();
        int i = 0;
        while (i < imgsize) {
            long time = imageList.get(i).getTime();
            this.imageInfos.put(time, imageList.get(i));
            ++i;
        }
    }

    public int getBinaryID(int pid, long time, long address) {
        int binID = -2;
        ProcessInformation process = this.getProcessInformation(pid);
        if (process == null) {
            Logger.warning((Object)("Failed to get binaryID (process info does not exist) for pid : " + pid));
        } else if (time > 0L) {
            LibraryObject obj = null;
            ProcessMemoryMap pmap = process.getProcessMemoryMap(time);
            if (pmap != null) {
                obj = pmap.getLibraryByAddress(address);
                binID = obj == null ? -1 : obj.getBinaryID();
            }
        }
        return binID;
    }

    public String[] getPageTabList() {
        return this.pageTabList;
    }

    public String[] getTimelineChartList() {
        return this.timelineChartList;
    }

    public boolean init(IProgress progress) {
        AppInfo curApp = Global.getCurrentApplication();
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        this.setProtocolVersion(curDev.getCommunicator().getProtocolVersion());
        this.setDeviceStatusInfo(curDev.getDeviceStatusInfo());
        this.setApplicationInfo(curApp);
        this.setAppID(curApp.getAppID());
        this.setPackageID(curApp.getPackageID());
        String deviceSerial = curDev.getIDevice().getSerialNumber();
        if (deviceSerial != null && !deviceSerial.isEmpty()) {
            this.setDevice(deviceSerial);
        } else {
            this.setDevice(" ");
        }
        this.setVersion(ProjectVersion.VERSION_LAST);
        Date date = new Date();
        this.setCreateTime(date.toString());
        this.setSavePath(String.valueOf(PathManager.DA_TEMP_FOLDER_PATH) + File.separator + Project.constructSaveName(this.getAppID(), date));
        File imgFolder = new File(String.valueOf(this.getSavePath()) + File.separator + "img");
        if (!imgFolder.isDirectory()) {
            if (!imgFolder.mkdirs()) {
                Logger.debug((Object)"image directory create failed...");
            } else {
                File smallImage = new File(String.valueOf(this.getSavePath()) + File.separator + "img" + File.separator + "small");
                if (!smallImage.isDirectory() && !smallImage.mkdirs()) {
                    Logger.debug((Object)"small image directory create failed...");
                }
            }
        }
        return !progress.testCancel();
    }

    public static String constructSaveName(String appName, Date date) {
        int length = appName.length() - 50;
        if (length > 0) {
            appName = appName.substring(0, 49);
        }
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        String saveFileName = String.valueOf(appName) + format.format(date);
        return saveFileName;
    }

    public boolean isWebApplication() {
        if (this.targetApplicationInfo != null) {
            return this.targetApplicationInfo.getAppType().equals("webapp");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SqlConnectionManager.closeConnection();
        this.version = ProjectVersion.VERSION_UNKNOWN;
        this.protocolVersion = null;
        this.device = null;
        this.packageID = null;
        this.appID = null;
        this.createTime = null;
        this.totalStopTime = -1L;
        this.replayStopTime = -1L;
        Object object = this.profilingStartTime_lock;
        synchronized (object) {
            this.profilingStartTime = null;
        }
        this.savePath = null;
    }

    public boolean isValid() {
        return ProjectVersion.VERSION_UNKNOWN != this.getVersion() && this.getAppID() != null && this.getPackageID() != null && this.getDevice() != null;
    }

    public boolean save() {
        boolean bret;
        block6: {
            if (!this.isValid()) {
                Logger.error((Object)"project save failed");
                return false;
            }
            bret = true;
            StringBuffer savefilename = new StringBuffer(this.getSavePath());
            savefilename.append(File.separator).append("projectInfo");
            File configFile = new File(savefilename.toString());
            FileWriter fileWriter = null;
            BufferedWriter buffWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(configFile);
                    buffWriter = new BufferedWriter(fileWriter);
                    this.savePrimitive(buffWriter);
                    this.saveTargetStatusInfo(buffWriter);
                    this.saveApplicationInfo(buffWriter);
                    this.saveFunctionInfo();
                    this.saveBinaryInfo();
                    this.saveProcessInfo();
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    bret = false;
                    CommonUtil.tryClose((Object[])new Object[]{buffWriter, fileWriter});
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{buffWriter, fileWriter});
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{buffWriter, fileWriter});
        }
        return bret;
    }

    private void savePrimitive(BufferedWriter writer) throws IOException {
        writer.write(PRIMITIVE_SECTION);
        writer.write(CommonConstants.NEW_LINE);
        writer.write("version=" + (Object)((Object)this.getVersion()));
        writer.write(CommonConstants.NEW_LINE);
        writer.write("protocolVersion=" + this.getProtocolVersion());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("device=" + this.getDevice());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("packageID=" + this.getPackageID());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("appName=" + this.getAppID());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("createTime=" + this.getCreateTime());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("totalStopTime=" + this.getTotalStopTime());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("daStartTime=" + this.getDAStartTime());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("availableMemps=" + this.getMempsAvailable());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("replayStopTime=" + this.getReplayStopTime());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("profilingStartTime=" + this.getProfilingStartTime());
        writer.write(CommonConstants.NEW_LINE);
        writer.write("pageTabList=" + StringUtil.concatenate(UIActionHolder.getUIAction().getPageNames(), (String)","));
        writer.write(CommonConstants.NEW_LINE);
        writer.write("timelineChartList=" + StringUtil.concatenate(UILayoutDataManager.INSTANCE.getSelectedChartSet(), (String)","));
        writer.write(CommonConstants.NEW_LINE);
        writer.write("lsanPreference=" + SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
        writer.write(CommonConstants.NEW_LINE);
        writer.write(CommonConstants.NEW_LINE);
        writer.flush();
    }

    private void saveTargetStatusInfo(BufferedWriter writer) throws IOException {
        writer.write(DEVICE_SECTION + CommonConstants.NEW_LINE);
        this.targetDeviceStatusInfo.savePrimitive(writer);
        writer.write(CommonConstants.NEW_LINE);
        writer.flush();
    }

    private void saveApplicationInfo(BufferedWriter writer) throws IOException {
        writer.write(APP_SECTION + CommonConstants.NEW_LINE);
        this.targetApplicationInfo.savePrimitive(writer);
        writer.write(CommonConstants.NEW_LINE);
        writer.flush();
    }

    private void saveFunctionInfo() {
        List<FunctionInfo> functions = this.functionInfos.getDataArray();
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        int size = functions.size();
        int i = 0;
        while (i < size) {
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            insertRowData.add(functions.get(i).getID());
            insertRowData.add(functions.get(i).getFunctionName());
            insertData.add(insertRowData);
            ++i;
        }
        if (insertData.size() > 0) {
            functionNameTable.insertData(insertData);
        }
    }

    private void saveBinaryInfo() {
        this.targetDeviceStatusInfo.saveBinaryInfo(binaryInfoTable);
    }

    private void saveProcessInfo() {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        for (Map.Entry<Integer, ProcessInformation> entry : this.processInfos.entrySet()) {
            ArrayList<Object> data = new ArrayList<Object>();
            ProcessInformation pinfo = entry.getValue();
            data.add(pinfo.getPid());
            data.add(pinfo.getPpid());
            data.add(pinfo.getStartTime());
            data.add(pinfo.getFunctionEntryLogCount());
            data.add(pinfo.isMainOrNot());
            data.add(pinfo.getProcessName());
            datas.add(data);
            pinfo.saveMemoryMap(memoryMapTable);
        }
        if (datas.size() > 0) {
            processInfoTable.insertData(datas);
        }
    }

    public boolean openDetail() {
        boolean bret;
        block7: {
            bret = true;
            BufferedReader in = this.getOpenReader(this.savePath);
            if (in != null) {
                try {
                    try {
                        this.openTargetStatusInfo(in);
                        this.openApplicationInfo(in);
                        this.openFunctionInfo();
                        this.openBinaryInfo();
                        this.openProcessInfo();
                    }
                    catch (IOException e) {
                        Logger.exception((Throwable)e);
                        bret = false;
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
            } else {
                bret = false;
            }
        }
        return bret;
    }

    private BufferedReader getOpenReader(String savePath) {
        BufferedReader reader = null;
        StringBuffer projectInfoSavedFile = new StringBuffer(savePath);
        projectInfoSavedFile.append(File.separator).append("projectInfo");
        File saveFile = new File(projectInfoSavedFile.toString());
        if (saveFile.isFile()) {
            try {
                reader = new BufferedReader(new FileReader(saveFile));
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                reader = null;
            }
        }
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean gotoSection(BufferedReader in, String sectionName) {
        try {
            String content;
            do {
                if ((content = in.readLine()) != null) continue;
                return false;
            } while (!content.trim().equals(sectionName));
            return true;
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
        return false;
    }

    private String openPrimitive(BufferedReader in) throws IOException {
        String ret = null;
        if (this.gotoSection(in, PRIMITIVE_SECTION)) {
            String content;
            while ((content = in.readLine()) != null) {
                if (content.trim().isEmpty()) break;
                String[] splitData = content.split("=");
                if (2 != splitData.length) continue;
                String infoKey = splitData[0];
                String val = splitData[1];
                if (infoKey.equals(VERSION)) {
                    ProjectVersion version = ProjectVersion.getVersion(val);
                    this.setVersion(version);
                    if (version != ProjectVersion.VERSION_UNKNOWN) continue;
                    ret = VERSION;
                    break;
                }
                if (infoKey.equals(PROTOCOL_VERSION)) {
                    this.setProtocolVersion(val);
                    continue;
                }
                if (infoKey.equals(DEVICE)) {
                    this.setDevice(val);
                    continue;
                }
                if (infoKey.equals(PACKAGEID)) {
                    this.setPackageID(val);
                    continue;
                }
                if (infoKey.equals(APPNAME)) {
                    this.setAppID(val);
                    continue;
                }
                if (infoKey.equals(CREATE_TIME)) {
                    this.setCreateTime(val);
                    continue;
                }
                if (infoKey.equals(TOTAL_STOP_TIME)) {
                    this.setTotalStopTime(Long.parseLong(val));
                    continue;
                }
                if (infoKey.equals(REPLAY_STOP_TIME)) {
                    this.setReplayStopTime(Long.parseLong(val));
                    continue;
                }
                if (infoKey.equals(PROFILE_START_TIME)) {
                    this.setProfilingStartTime(new DATime(val));
                    continue;
                }
                if (infoKey.equals(PAGE_TAB_LIST)) {
                    this.pageTabList = val.split(",");
                    continue;
                }
                if (infoKey.equals(TIMELINE_CHART_LIST)) {
                    this.timelineChartList = val.split(",");
                    continue;
                }
                if (infoKey.equals(MEMPS_DATA_AVAILABLE)) {
                    this.setMempsAvailable(Boolean.parseBoolean(val));
                    continue;
                }
                if (infoKey.equals(DA_START_TIME)) {
                    this.setDAStartTime(val);
                    continue;
                }
                if (!infoKey.equals(LSAN_PREFERENCE)) continue;
                SettingDataManager.INSTANCE.setPreferenceSelected(FlatPreferences.LEAK_SANITIZER, Boolean.parseBoolean(val));
            }
        } else {
            ret = PRIMITIVE_SECTION;
        }
        return ret;
    }

    private void openTargetStatusInfo(BufferedReader in) throws IOException {
        if (this.gotoSection(in, DEVICE_SECTION)) {
            if (this.targetDeviceStatusInfo == null) {
                this.targetDeviceStatusInfo = new DeviceStatusInfo();
            }
            this.targetDeviceStatusInfo.openPrimitive(in);
        }
    }

    private void openApplicationInfo(BufferedReader in) throws IOException {
        if (this.gotoSection(in, APP_SECTION)) {
            if (this.targetApplicationInfo == null) {
                this.targetApplicationInfo = new AppInfo();
            }
            this.targetApplicationInfo.openPrimitive(in);
        }
    }

    private void openFunctionInfo() {
        List<List<Object>> datas = functionNameTable.selectAllColumnData(null);
        if (datas == null) {
            Logger.error((Object)"failed - load function names");
        } else {
            ArrayList<String> namelist = new ArrayList<String>();
            ArrayList<FunctionInfo> finfolist = new ArrayList<FunctionInfo>();
            int maxindex = -1;
            int size = datas.size();
            int i = 0;
            while (i < size) {
                List<Object> functionInfo = datas.get(i);
                int id = (Integer)functionInfo.get(FunctionNameDBTable.COLUMN.FUNCTIONID.index);
                String name = (String)functionInfo.get(FunctionNameDBTable.COLUMN.FUNCTIONNAME.index);
                FunctionInfo finfo = new FunctionInfo(name);
                finfo.setID(id);
                namelist.add(name);
                finfolist.add(finfo);
                if (maxindex < id) {
                    maxindex = id;
                }
                ++i;
            }
            if (!this.functionInfos.buildFrom(namelist, finfolist, maxindex)) {
                Logger.error((Object)"failed to build function info map");
            }
        }
    }

    private void openBinaryInfo() {
        if (this.targetDeviceStatusInfo == null) {
            this.targetDeviceStatusInfo = new DeviceStatusInfo();
        }
        this.targetDeviceStatusInfo.openBinaryInfo(binaryInfoTable);
    }

    private void openProcessInfo() {
        this.processInfos.clear();
        List<List<Object>> datas = processInfoTable.selectAllColumnData(null);
        int rowsize = datas.size();
        int i = 0;
        while (i < rowsize) {
            List<Object> data = datas.get(i);
            ProcessInformation pinfo = new ProcessInformation();
            pinfo.setPid((Integer)data.get(0));
            pinfo.setPpid((Integer)data.get(1));
            pinfo.setStartTime((Long)data.get(2));
            pinfo.setFunctionEntryLogCount((Integer)data.get(3));
            pinfo.setMainOrNot((Boolean)data.get(4));
            pinfo.setProcessName((String)data.get(5));
            pinfo.openMemoryMap(memoryMapTable);
            this.putProcessInformation(pinfo);
            ++i;
        }
    }

    public void upgrade() {
        if (this.version == ProjectVersion.VERSION_LAST) {
            return;
        }
        this.setVersion(ProjectVersion.VERSION_LAST);
        if (this.pageTabList == null) {
            this.getPageTabListByDatabase();
        } else {
            List<String> pageNames = PageInfoRegistry.convertPageIDtoPageName(Arrays.asList(this.pageTabList));
            this.pageTabList = pageNames.toArray(new String[0]);
        }
        if (this.timelineChartList == null) {
            this.getChartListByDatabase();
        }
        this.rewriteProjectInfo();
    }

    private void rewriteProjectInfo() {
        block33: {
            ArrayList<String> lines;
            File saveFile;
            BufferedWriter writer;
            block31: {
                BufferedReader reader = null;
                writer = null;
                StringBuffer savefilename = new StringBuffer(this.getSavePath());
                savefilename.append(File.separator).append("projectInfo");
                saveFile = new File(savefilename.toString());
                if (saveFile.isFile()) {
                    try {
                        reader = new BufferedReader(new FileReader(saveFile));
                    }
                    catch (FileNotFoundException e) {
                        Logger.exception((Throwable)e);
                    }
                }
                lines = new ArrayList<String>();
                if (reader != null) {
                    boolean bFoundPrimitive = false;
                    boolean bFoundPageTab = false;
                    boolean bFoundChart = false;
                    boolean bUpgradeDone = false;
                    try {
                        try {
                            String content;
                            while ((content = reader.readLine()) != null) {
                                if (!bUpgradeDone) {
                                    if (!bFoundPrimitive && content.equals(PRIMITIVE_SECTION)) {
                                        bFoundPrimitive = true;
                                    } else if (bFoundPrimitive && content.startsWith(VERSION)) {
                                        content = "version=" + (Object)((Object)this.getVersion());
                                    } else if (bFoundPrimitive && content.startsWith(PAGE_TAB_LIST)) {
                                        bFoundPageTab = true;
                                        content = "pageTabList=" + StringUtil.concatenate((String[])this.pageTabList, (String)",");
                                    } else if (bFoundPrimitive && content.startsWith(TIMELINE_CHART_LIST)) {
                                        bFoundChart = true;
                                        content = "timelineChartList=" + StringUtil.concatenate((String[])this.timelineChartList, (String)",");
                                    } else if (bFoundPrimitive && content.trim().isEmpty()) {
                                        if (!bFoundPageTab) {
                                            lines.add("pageTabList=" + StringUtil.concatenate((String[])this.pageTabList, (String)","));
                                        }
                                        if (!bFoundChart) {
                                            lines.add("timelineChartList=" + StringUtil.concatenate((String[])this.timelineChartList, (String)","));
                                        }
                                        bFoundPrimitive = false;
                                        bUpgradeDone = true;
                                    }
                                }
                                lines.add(content);
                            }
                        }
                        catch (IOException e) {
                            Logger.exception((Throwable)e);
                            CommonUtil.tryClose((Object[])new Object[]{reader});
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{reader});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{reader});
                }
            }
            if (saveFile.isFile()) {
                try {
                    writer = new BufferedWriter(new FileWriter(saveFile));
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                }
            }
            if (writer != null) {
                try {
                    try {
                        for (String line : lines) {
                            writer.write(line);
                            writer.newLine();
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        Logger.exception((Throwable)e);
                        CommonUtil.tryClose((Object[])new Object[]{writer});
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{writer});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{writer});
            }
        }
    }

    private void getPageTabListByDatabase() {
        HashMap<String, Long> tableRowCount;
        block11: {
            tableRowCount = new HashMap<String, Long>();
            ResultSet rs = SqlConnectionManager.executeQueryRS(QUERY_TABLE_ROW_COUNT);
            if (rs != null) {
                try {
                    try {
                        while (rs.next()) {
                            tableRowCount.put(rs.getString(1), rs.getLong(2));
                        }
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                        SqlConnectionManager.releaseResultSet(rs);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    SqlConnectionManager.releaseResultSet(rs);
                    throw throwable;
                }
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        ArrayList<String> pageList = new ArrayList<String>();
        pageList.add(SettingConstants.PAGE_NAME_TIME_LINE);
        Long val = (Long)tableRowCount.get(TABLE_FOR_FILE_PAGE);
        if (val != null && val > 0L) {
            pageList.add(SettingConstants.PAGE_NAME_FILE);
        }
        if ((val = (Long)tableRowCount.get(TABLE_FOR_THREAD_PAGE)) != null && val > 0L) {
            pageList.add(SettingConstants.PAGE_NAME_THREAD);
        }
        if ((val = (Long)tableRowCount.get(TABLE_FOR_NETWORK_PAGE)) != null && val > 0L) {
            pageList.add(SettingConstants.PAGE_NAME_NETWORK);
        }
        if ((val = (Long)tableRowCount.get(TABLE_FOR_OPENGL_PAGE)) != null && val > 0L) {
            pageList.add(SettingConstants.PAGE_NAME_OPENGL);
        }
        pageList.add(SettingConstants.PAGE_NAME_SUMMARY);
        this.pageTabList = pageList.toArray(new String[0]);
    }

    private void getChartListByDatabase() {
        HashMap<String, Long> tableRowCount;
        block9: {
            tableRowCount = new HashMap<String, Long>();
            ResultSet rs = SqlConnectionManager.executeQueryRS(QUERY_TABLE_ROW_COUNT);
            if (rs != null) {
                try {
                    try {
                        while (rs.next()) {
                            tableRowCount.put(rs.getString(1), rs.getLong(2));
                        }
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                        SqlConnectionManager.releaseResultSet(rs);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SqlConnectionManager.releaseResultSet(rs);
                    throw throwable;
                }
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        ArrayList<String> chartList = new ArrayList<String>();
        chartList.add(TimelineChartLabels.CPU_CHART_TITLE);
        chartList.add(TimelineChartLabels.CPU_CORE_CHART_TITLE);
        chartList.add(TimelineChartLabels.CPU_FREQUENCY_CHART_TITLE);
        chartList.add(TimelineChartLabels.DEVICE_CHART_TITLE);
        chartList.add(TimelineChartLabels.DISK_IO_CHART_TITLE);
        chartList.add(TimelineChartLabels.ENERGY_CHART_TITLE);
        chartList.add(TimelineChartLabels.HEAP_CHART_TITLE);
        chartList.add(TimelineChartLabels.NETWORK_IO_CHART_TITLE);
        chartList.add(TimelineChartLabels.PROCESS_MEMORY_CHART_TITLE);
        chartList.add(TimelineChartLabels.SYSTEM_MEMORY_CHART_TITLE);
        Long val = (Long)tableRowCount.get(TABLE_FOR_SCREENSHOT_CHART);
        if (val != null && val > 0L) {
            chartList.add(TimelineChartLabels.SCREENSHOT_CHART_TITLE);
        }
        if ((val = (Long)tableRowCount.get(TABLE_FOR_UIEVENT_CHART)) != null && val > 0L) {
            chartList.add(TimelineChartLabels.UI_EVENT_CHART_TITLE);
        }
        this.timelineChartList = chartList.toArray(new String[0]);
    }

    public void setMempsAvailable(boolean available) {
        this.availableMemps = available;
    }

    public boolean getMempsAvailable() {
        return this.availableMemps;
    }

    public void setDAStartTime(String timestring) {
        this.daStartTime = timestring;
    }

    public String getDAStartTime() {
        return this.daStartTime;
    }

    public void setSavedData(boolean saved) {
        this.isSaved = saved;
    }

    public boolean getIsSavedData() {
        return this.isSaved;
    }

    public void setLoadedProject(boolean save) {
        this.isLoadedData = save;
    }

    public boolean isLoadedProject() {
        return this.isLoadedData;
    }
}

