/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemLSanTable50
extends DBTable {
    public static final String TABLENAME = "MEM_LSAN_DB_50";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemLSanTable50() {
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_MEMORY_SIZE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_MEMORY_OBJECTS_COUNT.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALL_STACK_STRING.name, "NOT NULL", "VARCHAR", 10000));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setLong(2, (Long)rowData.get(COLUMN.ALLOCATED_MEMORY_SIZE.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.ALLOCATED_MEMORY_OBJECTS_COUNT.index));
                prep.setString(4, (String)rowData.get(COLUMN.CALL_STACK_STRING.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getLong(2));
            row.add(rs.getInt(3));
            row.add(rs.getString(4));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PID(0, "PID"),
        ALLOCATED_MEMORY_SIZE(1, "ALLOCATED_MEMORY_SIZE"),
        ALLOCATED_MEMORY_OBJECTS_COUNT(2, "ALLOCATED_MEMORY_OBJECTS_COUNT"),
        CALL_STACK_STRING(3, "CALL_STACK_STRING");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

