/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSharingContextType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLStateSharingDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_SHARING";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String SHARING_CONTEXT_ID = "SHARING_CONTEXT_ID";
    public static final int TABLE_CONTEXT_ID_INDEX = 0;
    public static final int TABLE_SHARING_CONTEXT_ID_INDEX = 1;
    private static final String SELECT_QUERY = "select CONTEXT_ID,SHARING_CONTEXT_ID from GL_SHARING";
    List<GLSharingContextType> savedSharingInfoList = null;

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLStateSharingDBTableManager() {
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(SHARING_CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.savedSharingInfoList = new ArrayList<GLSharingContextType>();
    }

    public List<GLSharingContextType> selectSharingData() {
        ResultSet rs = SqlConnectionManager.executeQueryRS(SELECT_QUERY);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLSharingContextType> sharingInfoList = new ArrayList<GLSharingContextType>();
        try {
            while (rs.next()) {
                sharingInfoList.add(new GLSharingContextType(rs.getLong(1), rs.getLong(2)));
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return sharingInfoList;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setLong(2, (Long)rowData.get(1));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

