/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProfilingDataDBTable
extends DBTable {
    private static final String TABLENAME = "PROFILING_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ProfilingDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.PROFILING_DATA_ID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.BINARY_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.EXCLUSIVE_COUNT.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.INCLUSIVE_COUNT.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALL_COUNT.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.INCLUSIVE_EXECUTION_TIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.EXCLUSIVE_EXECUTION_TIME.name, "", "BIGINT"));
    }

    public List<List<Object>> getProfilingDataFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PROFILING_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.PROFILING_DATA_ID.index));
                prep.setByte(COLUMN.TYPE.index + 1, (Byte)rowData.get(COLUMN.TYPE.index));
                prep.setInt(COLUMN.FUNCTION_ID.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_ID.index));
                prep.setInt(COLUMN.BINARY_ID.index + 1, (Integer)rowData.get(COLUMN.BINARY_ID.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.EXCLUSIVE_COUNT.index + 1, (Integer)rowData.get(COLUMN.EXCLUSIVE_COUNT.index));
                prep.setInt(COLUMN.INCLUSIVE_COUNT.index + 1, (Integer)rowData.get(COLUMN.INCLUSIVE_COUNT.index));
                prep.setInt(COLUMN.CALL_COUNT.index + 1, (Integer)rowData.get(COLUMN.CALL_COUNT.index));
                prep.setLong(COLUMN.INCLUSIVE_EXECUTION_TIME.index + 1, (Long)rowData.get(COLUMN.INCLUSIVE_EXECUTION_TIME.index));
                prep.setLong(COLUMN.EXCLUSIVE_EXECUTION_TIME.index + 1, (Long)rowData.get(COLUMN.EXCLUSIVE_EXECUTION_TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getByte(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getInt(5));
            row.add(rs.getInt(6));
            row.add(rs.getInt(7));
            row.add(rs.getInt(8));
            row.add(rs.getLong(9));
            row.add(rs.getLong(10));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PROFILING_DATA_ID(0, "PROFILING_DATA_ID"),
        TYPE(1, "TYPE"),
        FUNCTION_ID(2, "FUNCTION_ID"),
        BINARY_ID(3, "BINARY_ID"),
        PID(4, "PID"),
        EXCLUSIVE_COUNT(5, "EXCLUSIVE_COUNT"),
        INCLUSIVE_COUNT(6, "INCLUSIVE_COUNT"),
        CALL_COUNT(7, "CALL_COUNT"),
        INCLUSIVE_EXECUTION_TIME(8, "INCLUSIVE_EXECUTION_TIME"),
        EXCLUSIVE_EXECUTION_TIME(9, "EXCLUSIVE_EXECUTION_TIME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

