/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;

public class DANotificationOnChartRenderer
extends DAChartRenderer {
    private static final int LEFT_OFFSET = 5;
    private static final int TOP_OFFSET = 4;
    private static final int LINE_OFFSET = 2;
    private final String[] notification;

    public DANotificationOnChartRenderer(String notification) {
        this.notification = notification.split("\n");
    }

    @Override
    public void draw(GC gc, DAChart chart, Image buffer) {
        super.draw(gc, chart, buffer);
        Rectangle rectangle = chart.getClientArea();
        Point[] line = new Point[this.notification.length];
        line[0] = new Point(rectangle.x + 5, rectangle.y + 4);
        int i = 1;
        while (i < line.length) {
            line[i] = new Point(line[i - 1].x, line[i - 1].y + 2 + gc.getFontMetrics().getHeight());
            ++i;
        }
        i = 0;
        while (i < line.length) {
            gc.drawString(this.notification[i], line[i].x, line[i].y, true);
            ++i;
        }
    }
}

