/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;

public class NetworkData
extends ProbeCommonData {
    protected long objectAddress = 0L;
    protected long fdValue = 0L;
    protected int fdApiType = 0;
    protected int destinationIPAddress = 0;
    protected int destinationPortAddress = 0;
    protected int messageSize = 0;
    protected String packetMessage = null;

    @Override
    public NetworkData clone() throws CloneNotSupportedException {
        NetworkData log = (NetworkData)super.clone();
        log.objectAddress = this.objectAddress;
        log.fdValue = this.fdValue;
        log.fdApiType = this.fdApiType;
        log.destinationIPAddress = this.destinationIPAddress;
        log.destinationPortAddress = this.destinationPortAddress;
        log.packetMessage = this.packetMessage;
        log.messageSize = this.messageSize;
        return log;
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        this.objectAddress = this.getLong();
        this.fdValue = this.getLong();
        this.fdApiType = this.getInt();
        this.destinationIPAddress = this.getInt();
        this.destinationPortAddress = this.getInt();
        this.messageSize = (int)this.getLong();
        this.packetMessage = this.messageSize > 0 ? this.getByteString(this.messageSize) : "";
        return true;
    }

    public long getObjectAddress() {
        return this.objectAddress;
    }

    public long getFdValue() {
        return this.fdValue;
    }

    public void setFdValue(long fdValue) {
        this.fdValue = fdValue;
    }

    public int getFdApiType() {
        return this.fdApiType;
    }

    public int getPacketMessageSize() {
        return this.messageSize;
    }

    public String getPacketMessage() {
        return this.packetMessage;
    }

    public String getdestinationIPAddress() {
        return NetworkData.intToIp(this.destinationIPAddress);
    }

    public String getDestinationPortAddress() {
        return Integer.toString(this.destinationPortAddress);
    }

    public String getDestinationAddress() {
        return String.valueOf(this.getdestinationIPAddress()) + CommonConstants.NEW_LINE + this.getDestinationPortAddress();
    }

    public void setFdApiType(int fdApiType) {
        this.fdApiType = fdApiType;
    }

    public static String intToIp(int integerIP) {
        return String.valueOf(integerIP & 0xFF) + "." + (integerIP >> 8 & 0xFF) + "." + (integerIP >> 16 & 0xFF) + "." + (integerIP >> 24 & 0xFF);
    }

    @Override
    public int getKey() {
        return (int)(this.fdValue ^ this.fdValue >>> 32);
    }
}

