/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool;

import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;

public enum HierarchyZoomManager {
    INSTANCE;

    private final double SCALE_RATE = 0.09;
    private final int MIN_STEP = 0;
    private final int MAX_STEP = 22;
    private HierarchyTreeView treeView;
    private int currentScaleStep = 11;

    public void setTreeView(HierarchyTreeView treeView) {
        this.treeView = treeView;
    }

    public void setCurrentScaleStep(int scaleStep) {
        if (scaleStep >= 0 && scaleStep <= 22) {
            this.currentScaleStep = scaleStep;
            this.treeView.refreshTree();
        }
    }

    public void zoomIn() {
        this.setCurrentScaleStep(this.currentScaleStep + 1);
    }

    public void zoomOut() {
        this.setCurrentScaleStep(this.currentScaleStep - 1);
    }

    public int getScaled(int pixel) {
        if (this.currentScaleStep > 0) {
            return (int)((double)pixel * 0.09 * (double)this.currentScaleStep);
        }
        return (int)((double)pixel * 0.09);
    }

    public HierarchyTreeView getTreeView() {
        return this.treeView;
    }
}

