/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.swap.model.data.AppStartupData;
import org.tizen.dynamicanalyzer.swap.model.data.ContextSwitchData;
import org.tizen.dynamicanalyzer.swap.model.data.ControlData;
import org.tizen.dynamicanalyzer.swap.model.data.ErrorData;
import org.tizen.dynamicanalyzer.swap.model.data.FileData;
import org.tizen.dynamicanalyzer.swap.model.data.FileSyscallData;
import org.tizen.dynamicanalyzer.swap.model.data.FunctionBodyInstrumentData;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LSanData;
import org.tizen.dynamicanalyzer.swap.model.data.LifeCycleLogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryMapData;
import org.tizen.dynamicanalyzer.swap.model.data.NetworkData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessAddInfoData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessInfoData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessStatusInfoData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.ReplayData;
import org.tizen.dynamicanalyzer.swap.model.data.SceneData;
import org.tizen.dynamicanalyzer.swap.model.data.ScreenShotData;
import org.tizen.dynamicanalyzer.swap.model.data.SyncData;
import org.tizen.dynamicanalyzer.swap.model.data.SyscallData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.swap.model.data.ThreadData;
import org.tizen.dynamicanalyzer.swap.model.data.UIEventData;
import org.tizen.dynamicanalyzer.swap.model.data.UIHierarchyData;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class LogDataFactory {
    public static LogData createInstance(byte[] header) {
        int msgID = ByteUtil.toInt((byte[])header, (int)0);
        LogData output = null;
        if (msgID < 16) {
            switch (msgID) {
                case 4: 
                case 8: 
                case 9: {
                    output = new ProfileData();
                    break;
                }
                case 10: 
                case 11: {
                    output = new SyscallData();
                    break;
                }
                case 12: 
                case 13: {
                    output = new FileSyscallData();
                    break;
                }
                case 5: {
                    output = new SystemData();
                    break;
                }
                case 7: {
                    output = new ReplayData();
                    break;
                }
                case 1: {
                    output = new ProcessInfoData();
                    break;
                }
                case 14: {
                    output = new ProcessStatusInfoData();
                    break;
                }
                case 2: {
                    output = new LogData();
                    break;
                }
                case 6: {
                    output = new LogData();
                    break;
                }
                case 3: {
                    output = new ErrorData();
                    break;
                }
                default: {
                    Logger.error((String)"Unknown message ID(%d)", (Object[])new Object[]{msgID});
                    break;
                }
            }
        } else if (msgID < 257) {
            switch (msgID) {
                case 18: 
                case 19: {
                    output = new MemoryMapData();
                    break;
                }
                case 16: 
                case 17: {
                    output = new ContextSwitchData();
                    break;
                }
                case 20: {
                    output = new ProcessAddInfoData();
                    break;
                }
                case 25: {
                    output = new AppStartupData();
                    break;
                }
                case 32: {
                    output = new FunctionBodyInstrumentData();
                    break;
                }
                case 33: {
                    output = new UIHierarchyData();
                    break;
                }
                case 34: {
                    output = new LSanData();
                    break;
                }
                default: {
                    Logger.error((String)"Unknown message ID(%d)", (Object[])new Object[]{msgID});
                    break;
                }
            }
        } else {
            switch (msgID) {
                case 257: {
                    output = new MemoryData();
                    break;
                }
                case 274: {
                    output = new GLES20LogData();
                    break;
                }
                case 260: {
                    output = new FileData();
                    break;
                }
                case 273: {
                    output = new NetworkData();
                    break;
                }
                case 264: {
                    output = new ThreadData();
                    break;
                }
                case 272: {
                    output = new SyncData();
                    break;
                }
                case 262: {
                    output = new ScreenShotData();
                    break;
                }
                case 258: {
                    output = new ControlData();
                    break;
                }
                case 259: {
                    output = new UIEventData();
                    break;
                }
                case 261: {
                    output = new LifeCycleLogData();
                    break;
                }
                case 263: {
                    output = new SceneData();
                    break;
                }
                default: {
                    Logger.error((String)"Unknown message ID(%d)", (Object[])new Object[]{msgID});
                }
            }
        }
        if (output != null) {
            output.init(header);
        } else {
            output = new LogData();
            output.init(header);
            output.setMsgID(0);
        }
        return output;
    }

    public static String getLogFormatName(int id) {
        String formatName = null;
        switch (id) {
            case 257: {
                formatName = "Memory";
                break;
            }
            case 258: {
                formatName = "Control";
                break;
            }
            case 259: {
                formatName = "UIEvent";
                break;
            }
            case 260: {
                formatName = "File";
                break;
            }
            case 273: {
                formatName = "Network";
                break;
            }
            case 274: {
                formatName = "GLES20";
                break;
            }
            case 261: {
                formatName = "LifeCycle";
                break;
            }
            case 262: {
                formatName = "ScreenShot";
                break;
            }
            case 263: {
                formatName = "Scene";
                break;
            }
            case 264: {
                formatName = "Thread";
                break;
            }
            case 272: {
                formatName = "Sync";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                formatName = "Profiling";
                break;
            }
            case 16: 
            case 17: {
                formatName = "ContextSwitch";
                break;
            }
            case 5: {
                formatName = "System";
                break;
            }
            case 7: {
                break;
            }
            case 25: {
                formatName = "AppStartup";
                break;
            }
            case 10: 
            case 11: {
                formatName = "SystemCall";
                break;
            }
            case 32: {
                formatName = "FunctionBodyInstrument";
                break;
            }
            case 12: 
            case 13: {
                formatName = "FileUsage";
                break;
            }
            case 34: {
                formatName = "LeakSanitizer";
                break;
            }
        }
        return formatName;
    }
}

