/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

public final class Flags {
    private Flags() {
    }

    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isExport(int flags) {
        return (flags & 0x200) != 0;
    }

    public static boolean isInline(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isExplicit(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isExtern(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isMutable(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isRegister(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isVirtual(int flags) {
        return (flags & 0x20000) != 0;
    }

    public static boolean isVolatile(int flags) {
        return (flags & 0x40) != 0;
    }

    public static String toString(int flags) {
        int len;
        StringBuffer sb = new StringBuffer();
        if (Flags.isPublic(flags)) {
            sb.append("public ");
        }
        if (Flags.isProtected(flags)) {
            sb.append("protected ");
        }
        if (Flags.isPrivate(flags)) {
            sb.append("private ");
        }
        if (Flags.isStatic(flags)) {
            sb.append("static ");
        }
        if (Flags.isAbstract(flags)) {
            sb.append("abstract ");
        }
        if (Flags.isVirtual(flags)) {
            sb.append("virtual ");
        }
        if (Flags.isInline(flags)) {
            sb.append("inline ");
        }
        if (Flags.isExtern(flags)) {
            sb.append("extern ");
        }
        if (Flags.isExport(flags)) {
            sb.append("export ");
        }
        if (Flags.isVolatile(flags)) {
            sb.append("volatile ");
        }
        if (Flags.isExplicit(flags)) {
            sb.append("explicit ");
        }
        if ((len = sb.length()) == 0) {
            return "";
        }
        sb.setLength(len - 1);
        return sb.toString();
    }
}

