/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProviderFactory;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.EDCSymbolReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ElfExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.OSChecker;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.util.Logger;

public class SymbolManager {
    private static Map<IPath, WeakReference<IEDCSymbolReader>> readerCache = new HashMap<IPath, WeakReference<IEDCSymbolReader>>();
    private static Map<String, WeakReference<Elf>> elfCache = new HashMap<String, WeakReference<Elf>>();
    private static Map<String, SoftReference<MapHolder>> mapHolderCache = new HashMap<String, SoftReference<MapHolder>>();
    private static Pattern header = Pattern.compile("^ <[0-5]><([a-f0-9]+)>: Abbrev Number: .*$");

    public static byte[] stringToBytesASCII(String str) {
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)buffer[i];
            ++i;
        }
        return b;
    }

    public static IEDCSymbolReader getSymbolReader(IPath path) {
        ElfExecutableSymbolicsReaderFactory provider;
        IExecutableSymbolicsReader exeReader;
        IEDCSymbolReader reader = null;
        WeakReference<IEDCSymbolReader> cacheEntry = readerCache.get(path);
        if (cacheEntry != null) {
            reader = (IEDCSymbolReader)cacheEntry.get();
        }
        if (reader != null) {
            if (reader.getSymbolFile() != null && reader.getSymbolFile().toFile().exists() && reader.getSymbolFile().toFile().lastModified() == reader.getModificationDate()) {
                return reader;
            }
            readerCache.remove(path);
        }
        if ((exeReader = (provider = new ElfExecutableSymbolicsReaderFactory()).createExecutableSymbolicsReader(path)) != null) {
            DwarfDebugInfoProviderFactory providerProvider = new DwarfDebugInfoProviderFactory();
            IDebugInfoProvider dprovider = providerProvider.createDebugInfoProvider(path, exeReader);
            if (dprovider != null && !exeReader.getSymbolFile().equals((Object)dprovider.getExecutableSymbolicsReader().getSymbolFile())) {
                exeReader.dispose();
                exeReader = dprovider.getExecutableSymbolicsReader();
            }
            reader = new EDCSymbolReader(exeReader, dprovider);
        }
        if (reader != null) {
            readerCache.put(path, new WeakReference<IEDCSymbolReader>(reader));
        }
        return reader;
    }

    public static SourceLine addr2line(String strPath, long address, boolean isPieBuild, String strBaseAddr) {
        IModuleLineEntryProvider moduleLineEntryProvider;
        IEDCSymbolReader reader;
        Addr32 addr;
        SourceLine srcline = new SourceLine();
        if (strPath == null || strPath.isEmpty()) {
            srcline.setError(1);
            return srcline;
        }
        if (address < 0L) {
            srcline.setError(2);
            return srcline;
        }
        Path path = new Path(strPath);
        if (!path.toFile().exists()) {
            srcline.setError(3);
            return srcline;
        }
        try {
            addr = new Addr32(Long.toString(address));
        }
        catch (NumberFormatException numberFormatException) {
            srcline.setError(4);
            return srcline;
        }
        if (isPieBuild) {
            Addr32 offsetAddr;
            Addr32 baseAddr;
            if (strBaseAddr == null || strBaseAddr.isEmpty()) {
                srcline.setError(2);
                return srcline;
            }
            try {
                baseAddr = new Addr32(strBaseAddr);
            }
            catch (NumberFormatException numberFormatException) {
                srcline.setError(4);
                return srcline;
            }
            addr = offsetAddr = new Addr32(baseAddr.distanceTo((IAddress)addr).longValue());
        }
        try {
            reader = SymbolManager.getSymbolReader((IPath)path);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            srcline.setError(5);
            return srcline;
        }
        if (reader != null && (moduleLineEntryProvider = reader.getModuleScope().getModuleLineEntryProvider()) != null) {
            ILineEntry lineEntry = moduleLineEntryProvider.getLineEntryAtAddress((IAddress)addr);
            if (lineEntry != null) {
                if (lineEntry.getLowAddress().compareTo((Object)addr) == 0) {
                    ILineEntry prevEntry = moduleLineEntryProvider.getPreviousLineEntry(lineEntry, false);
                    if (prevEntry != null) {
                        srcline.setLineEntry(prevEntry);
                        return srcline;
                    }
                    srcline.setLineEntry(lineEntry);
                    return srcline;
                }
                srcline.setLineEntry(lineEntry);
                return srcline;
            }
            srcline.setError(6);
            return srcline;
        }
        srcline.setError(7);
        return srcline;
    }

    public static String addr2func(String strBinPath, String strAddr, boolean isPieBuild, String strBaseAddr) {
        Elf.Symbol sym;
        if (strBinPath == null || strBinPath.isEmpty()) {
            return AnalyzerLabels.SYMBOL_MANAGER_UNKNOWN;
        }
        if (!new File(strBinPath).exists()) {
            return AnalyzerLabels.SYMBOL_MANAGER_UNKNOWN;
        }
        if (strAddr == null || strAddr.isEmpty()) {
            return AnalyzerLabels.SYMBOL_MANAGER_UNKNOWN;
        }
        if (isPieBuild && (strBaseAddr == null || strBaseAddr.isEmpty())) {
            return AnalyzerLabels.SYMBOL_MANAGER_UNKNOWN;
        }
        Addr32 addr = new Addr32(strAddr);
        if (isPieBuild) {
            Addr32 offsetAddr;
            Addr32 baseAddr = new Addr32(strBaseAddr);
            addr = offsetAddr = new Addr32(baseAddr.distanceTo((IAddress)addr).longValue());
        }
        Elf elf = null;
        WeakReference<Elf> elfEntry = elfCache.get(strBinPath);
        if (elfEntry != null) {
            elf = (Elf)elfEntry.get();
        }
        if (elf == null) {
            try {
                elf = new Elf(strBinPath);
                elf.loadSymbols();
                elfCache.put(strBinPath, new WeakReference<Elf>(elf));
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                return null;
            }
        }
        if ((sym = elf.getSymbol((IAddress)addr)) == null) {
            return null;
        }
        return sym.toString();
    }

    public static String demanglingFunctionName(String sourcePath, String mangled) {
        String demangled;
        block2: {
            UnmanglerEABI unmangler = null;
            demangled = null;
            unmangler = new UnmanglerEABI();
            try {
                demangled = unmangler.unmangle(mangled.trim());
            }
            catch (UnmanglingException unmanglingException) {
                demangled = SymbolManager.searchInDebugInfo(sourcePath, mangled);
                if (demangled != null && !demangled.equals(mangled)) break block2;
                int length = mangled.trim().length();
                length = length > 128 ? 128 : length;
                demangled = mangled.trim().substring(0, length - 1);
                Logger.debug((Object)("demangling failed :" + mangled));
            }
        }
        return demangled;
    }

    private static String searchInDebugInfo(String sourcePath, String mangled) {
        SoftReference<MapHolder> ref = mapHolderCache.get(sourcePath);
        MapHolder holder = null;
        if (ref != null) {
            holder = ref.get();
        }
        if (holder == null) {
            holder = new MapHolder(sourcePath);
            mapHolderCache.put(sourcePath, new SoftReference<MapHolder>(holder));
        }
        return (String)holder.demangledBYMangled.get(mangled);
    }

    public static int getFuncId(ProfileData input, long address, int pid, long time) {
        Project project = Global.getProject();
        ProcessInformation process = project.getProcessInformation(pid);
        int functionID = process.getFunctionID(address);
        if (functionID >= 0) {
            return functionID;
        }
        String functionName = null;
        ProcessMemoryMap pmap = process.getProcessMemoryMap(time);
        if (pmap != null) {
            LibraryObject libraryObject = pmap.getLibraryByAddress(address);
            String baseAddr = Long.toString(libraryObject.getLowestAddress());
            String pcStr = Long.toString(address);
            BinaryInfo binInfo = project.getDeviceStatusInfo().getBinaryInfo(libraryObject.getBinaryID());
            if (binInfo != null) {
                String localPath = binInfo.getTempBinaryPath();
                if (input != null) {
                    input.setBuildType(binInfo.getType());
                }
                boolean isPieBuild = true;
                if (binInfo.getType() != 1) {
                    isPieBuild = false;
                }
                functionName = SymbolManager.addr2func(localPath, pcStr, isPieBuild, baseAddr);
            }
        }
        if (functionName == null || functionName.isEmpty()) {
            functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
        } else if (functionName.equals("_end")) {
            Logger.error((Object)"function name : _end occurred!\n");
            functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
        } else {
            String prevFunctionName = functionName;
            String path = project.getDeviceStatusInfo().getBinaryInfo(project.getBinaryID(pid, time, address)).getTempBinaryPath();
            functionName = SymbolManager.demanglingFunctionName(path, prevFunctionName);
        }
        functionID = project.getFunctionID(functionName);
        process.putFunctionID(address, functionID);
        return functionID;
    }

    static class MapHolder {
        String path;
        private Map<String, String> demangledBYMangled = new HashMap<String, String>();
        private Map<String, String> demangledAdrressBYMangled = new HashMap<String, String>();
        private Map<String, String> demangledBYdemangledAddress = new HashMap<String, String>();

        public MapHolder(String path) {
            this.path = path;
            this.buildSymbolsByDebugInfo();
        }

        private void buildSymbolsByDebugInfo() {
            String cmd = String.valueOf(PathManager.TIZEN_SDK_INSTALL_PATH) + File.separator + "tools" + PathManager.getBinaryToolsPath((boolean)Global.getCurrentDeviceInfo().isEmulator()) + "readelf" + (OSChecker.isWindows() ? ".exe" : "") + " -zw --wide " + this.path;
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = br.readLine();
                while (line != null) {
                    if ("Contents of the .debug_info section:".equals(line)) break;
                    line = br.readLine();
                }
                while (line != null) {
                    Matcher m = header.matcher(line);
                    line = m.find() ? this.parseDwarfBlock(m.group(1), br) : br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                Logger.error((Object)e);
            }
            if (!this.demangledAdrressBYMangled.isEmpty()) {
                for (Map.Entry<String, String> pair : this.demangledAdrressBYMangled.entrySet()) {
                    String demangled = this.demangledBYdemangledAddress.get(pair.getValue());
                    if (demangled == null) {
                        Logger.error((Object)("Can't find specification for" + pair.getKey()));
                        continue;
                    }
                    this.demangledBYMangled.put(pair.getKey(), demangled);
                }
            }
        }

        private String parseDwarfBlock(String line, BufferedReader br) throws IOException {
            String buf;
            String linkageName = null;
            String name = null;
            String specification = null;
            Pattern secHeader = Pattern.compile("^Contents of the .[a-zA-Z_0-9]+ section:$");
            while ((buf = br.readLine()) != null) {
                if (secHeader.matcher(buf).matches()) {
                    buf = null;
                    break;
                }
                if (header.matcher(buf).matches()) break;
                if (buf.contains("DW_AT_linkage_name")) {
                    linkageName = buf.substring(buf.lastIndexOf(": ") + 2);
                    continue;
                }
                if (buf.contains("DW_AT_name")) {
                    name = buf.substring(buf.lastIndexOf(": ") + 2);
                    continue;
                }
                if (!buf.contains("DW_AT_specification")) continue;
                specification = buf.substring(buf.lastIndexOf(120) + 1, buf.lastIndexOf(62));
            }
            if (linkageName != null) {
                if (name != null) {
                    this.demangledBYMangled.put(linkageName, name);
                } else if (specification != null) {
                    this.demangledAdrressBYMangled.put(linkageName, specification);
                }
            } else if (name != null && line != null) {
                this.demangledBYdemangledAddress.put(line, name);
            }
            return buf;
        }
    }

    public static class SourceLine {
        private ILineEntry lineEntry;
        private int errorNo = 0;

        public SourceLine() {
            this.lineEntry = null;
        }

        public SourceLine(ILineEntry lineEntry) {
            this.lineEntry = lineEntry;
        }

        public int getError() {
            return this.errorNo;
        }

        public void setError(int errorNo) {
            this.errorNo = errorNo;
        }

        public void setLineEntry(ILineEntry lineEntry) {
            this.lineEntry = lineEntry;
        }

        public boolean isValid() {
            return this.lineEntry != null && this.errorNo == 0;
        }

        public String getFilePath() {
            String filePath = this.lineEntry.getFilePath().toString();
            try {
                return new String(SymbolManager.stringToBytesASCII(filePath), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.exception((Throwable)e);
                return filePath;
            }
        }

        public int getLineNumber() {
            return this.lineEntry.getLineNumber();
        }
    }
}

