/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.util.Arrays;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.swap.communicator.SwapErrorCode;

public class AckMessage {
    private int msgID = -1;
    private int payloadLength = -1;
    private int returnCode = -1;
    private byte[] payload = null;
    public static AckMessage NOACK = new AckMessage(SwapErrorCode.SUCCESS);

    public AckMessage() {
    }

    private AckMessage(SwapErrorCode errorcode) {
        this.msgID = 0;
        this.returnCode = errorcode.getErrorNumber();
    }

    public int getMsgID() {
        return this.msgID;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isSuccess() {
        return this.returnCode == SwapErrorCode.SUCCESS.getErrorNumber();
    }

    public boolean isCorrectID(int msgid) {
        return this.msgID == msgid;
    }

    public void parseAck(byte[] message) {
        ProtocolParser parser = new ProtocolParser(message);
        this.msgID = parser.getInt();
        this.payloadLength = parser.getInt();
        if (this.payloadLength > 0) {
            this.payload = Arrays.copyOfRange(message, parser.getIndex(), message.length);
            this.returnCode = parser.getInt();
        }
    }
}

