/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p40;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ISerializable;
import org.tizen.dynamicanalyzer.communicator.ProtocolSerializer;

public class FunctionBodyInstrumentVariable40
implements ISerializable {
    private long variableID;
    private long registerOffset;
    private byte registerNum;
    private int dataSize;
    private List<ISerializable> steps = new ArrayList<ISerializable>();

    public FunctionBodyInstrumentVariable40(long variableID, long registerOffset, byte registerNum, int dataSize) {
        this.variableID = variableID;
        this.registerOffset = registerOffset;
        this.registerNum = registerNum;
        this.dataSize = dataSize;
    }

    public void addStep(ISerializable step) {
        this.steps.add(step);
    }

    @Override
    public void serialize(ProtocolSerializer ps) {
        ps.putLong(this.variableID);
        ps.putLong(this.registerOffset);
        ps.putByte(this.registerNum);
        ps.putInt(this.dataSize);
        ps.putByte((byte)this.steps.size());
        int size = this.steps.size();
        int i = size - 1;
        while (i >= 0) {
            this.steps.get(i).serialize(ps);
            --i;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof FunctionBodyInstrumentVariable40) {
            return this.variableID == ((FunctionBodyInstrumentVariable40)o).variableID;
        }
        return false;
    }
}

