/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmGengridProperties
extends HierarchyUIObjectProperties {
    private double xAlign;
    private double yAlign;
    private boolean filled;
    private double hPageRelative;
    private double vPageRelative;
    private boolean multiSelect;
    private int[] groupItemSize = new int[2];
    private String selectMode;
    private boolean reorderMode;
    private boolean highlightMode;
    private int[] itemSize = new int[2];
    private String multiSelectMode;
    private boolean horizontal;
    private boolean wheelDisabled;
    private int itemCount;

    public ElmGengridProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.xAlign = parser.getFloat();
        this.yAlign = parser.getFloat();
        this.filled = parser.getBoolean();
        this.hPageRelative = parser.getFloat();
        this.vPageRelative = parser.getFloat();
        this.multiSelect = parser.getBoolean();
        this.groupItemSize[0] = parser.getInt();
        this.groupItemSize[1] = parser.getInt();
        this.selectMode = this.getSelectModeMessage(parser.getChar());
        this.reorderMode = parser.getBoolean();
        this.highlightMode = parser.getBoolean();
        this.itemSize[0] = parser.getInt();
        this.itemSize[1] = parser.getInt();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.multiSelectMode = this.getMultiSelectModeMessage(parser.getChar());
        }
        this.horizontal = parser.getBoolean();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.wheelDisabled = parser.getBoolean();
        }
        this.itemCount = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("xAlign", Double.toString(this.xAlign)));
        properties.add(new PropertyValue("yAlign", Double.toString(this.yAlign)));
        properties.add(new PropertyValue("filled", Boolean.toString(this.filled)));
        properties.add(new PropertyValue("hPageRelative", Double.toString(this.hPageRelative)));
        properties.add(new PropertyValue("vPageRelative", Double.toString(this.vPageRelative)));
        properties.add(new PropertyValue("multiSelect", Boolean.toString(this.multiSelect)));
        properties.add(new PropertyValue("groupItemSize", "[" + this.groupItemSize[0] + ", " + this.groupItemSize[1] + "]"));
        properties.add(new PropertyValue("selectMode", this.selectMode));
        properties.add(new PropertyValue("reorderMode", Boolean.toString(this.reorderMode)));
        properties.add(new PropertyValue("highlightMode", Boolean.toString(this.highlightMode)));
        properties.add(new PropertyValue("itemSize", "[" + this.itemSize[0] + ", " + this.itemSize[1] + "]"));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("multiSelectMode", this.multiSelectMode));
        }
        properties.add(new PropertyValue("horizontal", Boolean.toString(this.horizontal)));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("wheelDisabled", Boolean.toString(this.wheelDisabled)));
        }
        properties.add(new PropertyValue("itemCount", Integer.toString(this.itemCount)));
        return properties;
    }

    private String getSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_SELECT_MODE_ALWAYS";
            }
            case 2: {
                return "ELM_OBJECT_SELECT_MODE_NONE";
            }
            case 3: {
                return "ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY";
            }
            case 4: {
                return "ELM_OBJECT_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getMultiSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_WITH_CONTROL";
            }
            case 2: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

