/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeBranchLayout;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeLayout;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeNodeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;

public class HierarchyTreeFigure
extends Figure {
    private IFigure branch = new Layer();
    private HierarchyTreeNodeFigure node;
    private static final int BEZIERCONTROL = 25;
    private int[] cachedContourLeft;
    private int[] cachedContourRight;
    private int depth = -1;

    public HierarchyTreeFigure(HierarchyTreeNodeFigure node) {
        this.setLayoutManager((LayoutManager)new HierarchyTreeLayout());
        this.branch.setLayoutManager((LayoutManager)new HierarchyTreeBranchLayout());
        this.node = node;
        this.add(this.branch);
        this.add((IFigure)this.node);
    }

    public IFigure getBranch() {
        return this.branch;
    }

    public HierarchyTreeNodeFigure getNode() {
        return this.node;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        this.validate();
        Dimension size = super.getPreferredSize(wHint, hHint);
        return size;
    }

    public boolean containsPoint(int x, int y) {
        return this.node.containsPoint(x, y) || this.branch.containsPoint(x, y);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (!this.node.isHidden()) {
            this.drawConnections(graphics);
        }
    }

    void drawConnections(Graphics g) {
        HierarchyTreeNodeFigure node = this.getNode();
        int left = node.getBounds().right();
        int right = this.getBranch().getBounds().x - 1;
        int yMid = node.getBounds().getCenter().y;
        List children = this.branch.getChildren();
        if (children.size() == 0) {
            return;
        }
        Path bezierPath = new Path((Device)Display.getCurrent());
        g.setForegroundColor(ColorResources.TREEVIEW_LINE);
        g.setAntialias(1);
        int i = 0;
        while (i < children.size()) {
            int y = ((HierarchyTreeFigure)((Object)children.get((int)i))).getNode().getBounds().getCenter().y;
            bezierPath.moveTo((float)left, (float)yMid);
            if (yMid != y) {
                int bezierControl = HierarchyZoomManager.INSTANCE.getScaled(25);
                bezierPath.cubicTo((float)(left + bezierControl), (float)yMid, (float)(right - bezierControl), (float)y, (float)right, (float)y);
            } else {
                bezierPath.cubicTo((float)left, (float)yMid, (float)right, (float)y, (float)right, (float)y);
            }
            g.drawPath(bezierPath);
            ++i;
        }
    }

    void updateContours() {
        HierarchyTreeFigure subtree;
        this.cachedContourLeft = new int[this.getDepth()];
        this.cachedContourRight = new int[this.getDepth()];
        Rectangle clientArea = this.node.getBounds().getUnion(this.branch.getBounds());
        Rectangle nodeBounds = this.node.getBounds();
        this.cachedContourLeft[0] = nodeBounds.y - clientArea.y;
        this.cachedContourRight[0] = clientArea.bottom() - nodeBounds.bottom();
        List subtrees = this.branch.getChildren();
        int currentDepth = 0;
        int i = 0;
        while (i < subtrees.size() && currentDepth < this.getDepth()) {
            subtree = (HierarchyTreeFigure)((Object)subtrees.get(i));
            if (subtree.getDepth() > currentDepth) {
                int[] leftContour = subtree.getContourLeft();
                int leftOffset = subtree.getBounds().y - clientArea.y;
                this.mergeContour(this.cachedContourLeft, leftContour, currentDepth, leftOffset);
                currentDepth = subtree.getDepth();
            }
            ++i;
        }
        currentDepth = 0;
        i = subtrees.size() - 1;
        while (i >= 0 && currentDepth < this.getDepth()) {
            subtree = (HierarchyTreeFigure)((Object)subtrees.get(i));
            if (subtree.getDepth() > currentDepth) {
                int[] rightContour = subtree.getContourRight();
                int rightOffset = clientArea.bottom() - subtree.getBounds().bottom();
                this.mergeContour(this.cachedContourRight, rightContour, currentDepth, rightOffset);
                currentDepth = subtree.getDepth();
            }
            --i;
        }
    }

    void mergeContour(int[] destination, int[] source, int startdepth, int offset) {
        int i = startdepth;
        while (i < source.length) {
            destination[i + 1] = source[i] + offset;
            ++i;
        }
    }

    public int[] getContourLeft() {
        this.updateContours();
        return this.cachedContourLeft;
    }

    public int[] getContourRight() {
        this.updateContours();
        return this.cachedContourRight;
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.calculateDepth();
        }
        return this.depth;
    }

    void calculateDepth() {
        this.depth = 0;
        List subtrees = this.branch.getChildren();
        int i = 0;
        while (i < subtrees.size()) {
            this.depth = Math.max(this.depth, ((HierarchyTreeFigure)((Object)subtrees.get(i))).getDepth());
            ++i;
        }
        ++this.depth;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int level) {
        String result = "";
        int i = 0;
        while (i < level) {
            result = String.valueOf(result) + "  ";
            ++i;
        }
        result = String.valueOf(result) + this.getChildren().get(1) + "\n";
        i = 0;
        while (i < this.branch.getChildren().size()) {
            result = String.valueOf(result) + ((HierarchyTreeFigure)((Object)this.branch.getChildren().get(i))).toString(level + 1);
            ++i;
        }
        return result;
    }
}

