/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.process;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.info.process.ProcessDataManager;
import org.tizen.dynamicanalyzer.ui.info.process.ProcessTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ProcessView
extends DAViewComposite {
    ProcessTable tableComp = null;
    private String[] observingViews = null;
    private boolean[] columnVisibility = new boolean[]{true, true, true};
    private int[] columnAlignment = new int[]{16384, 16384, 131072};
    private String[] columnNames = new String[]{InformationViewLabels.APP_PROCESS_VIEW_PROCESS_NAME, InformationViewLabels.APP_PROCESS_VIEW_PID, InformationViewLabels.APP_PROCESS_VIEW_CPU};
    int[] sortTypes = new int[]{3, 1, 1};

    public ProcessView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.APP_PROCESS_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new ProcessTable(contents, 0, 68352);
        this.tableComp.setTableName(InformationViewLabels.APP_PROCESS_VIEW_TITLE);
        this.tableComp.setComparator(new DefaultTableComparator());
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setDefaultSortColumn(2, false);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames, this.columnAlignment);
        this.tableComp.setColumnVisibility(this.columnVisibility);
        this.tableComp.setTableToolTipEnable(false);
        this.tableComp.getTable().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Composite contents = (Composite)e.widget;
                Rectangle rect = contents.getClientArea();
                int nameColumnSize = (int)((double)rect.width * 0.65);
                int pidColumnSize = (int)((double)rect.width * 0.18);
                int cpuColumnSize = rect.width - (nameColumnSize + pidColumnSize);
                int[] newColumnSizes = new int[]{nameColumnSize, pidColumnSize, cpuColumnSize};
                ProcessView.this.tableComp.setColumnSize(newColumnSizes);
            }
        });
        DataManagerRegistry.registerPageDataManager(ProcessDataManager.getInstance());
    }

    public void updateView() {
        this.tableComp.updateTable();
    }

    public void updateView(DAViewData vdata) {
    }

    public void clear() {
        this.tableComp.clear();
        ProcessDataManager.getInstance().clear();
    }

    public Control getControl() {
        return this.tableComp;
    }

    public void setObservingViews(String[] viewIDs) {
        this.observingViews = viewIDs;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }
}

