/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryMapTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryMapView
extends DAViewComposite {
    public static final String ID = MemoryMapView.class.getName();
    MemoryMapTable tableComp = null;

    public MemoryMapView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(MemoryPageLabels.MEMORY_MAP_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new MemoryMapTable(contents, 0, 68354);
        this.tableComp.setSelectionTime(-1L);
    }

    public void updateView() {
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableComp == null) {
            return;
        }
        this.tableComp.updateTable();
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)vdata;
        if (selData.getStartTime() == selData.getEndTime()) {
            this.tableComp.setSelectionTime(selData.getStartTime());
        } else {
            this.tableComp.setSelectionTime(-1L);
        }
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        this.tableComp.updateTable();
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

