/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemLSanTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemLSanTable50;
import org.tizen.dynamicanalyzer.util.Logger;

public class LsanDataManager
extends PageDataManager {
    private static LsanDataManager instance = new LsanDataManager();
    private Map<Long, List<Object>> leaksMap = new HashMap<Long, List<Object>>();
    private List<List<Object>> leaksList = new ArrayList<List<Object>>();

    public static LsanDataManager getInstance() {
        return instance;
    }

    public Map<Long, List<Object>> getLeaksMap() {
        return this.leaksMap;
    }

    public List<List<Object>> getLeaksList() {
        return this.leaksList;
    }

    @Override
    protected void resetBeforeStart() {
        this.leaksMap.clear();
        this.leaksList.clear();
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        if (Global.getCurrentProtocol().getVersionNum() >= Protocol.VERSION_50.getVersionNum()) {
            MemLSanTable50 lsanDBTable = new MemLSanTable50();
            this.constructLeaksList(lsanDBTable.selectAllObjectData());
        } else {
            MemLSanTable lsanDBTable = new MemLSanTable();
            this.constructLeaksMap(lsanDBTable.selectAllObjectData());
        }
    }

    private void constructLeaksList(List<List<Object>> leaks) {
        this.leaksList = leaks;
    }

    private void constructLeaksMap(List<List<Object>> leaks) {
        this.leaksMap.clear();
        for (List<Object> row : leaks) {
            this.leaksMap.put((Long)row.get(MemLSanTable.COLUMN.ALLOCATED_ADDRESS.index), row);
        }
    }

    public void parseLSanReportFile(String filepath) {
        if (Global.getCurrentProtocol().getVersionNum() >= Protocol.VERSION_50.getVersionNum()) {
            MemLSanTable50 lsanDBTable = new MemLSanTable50();
            DBInserter lsanDBInserter = this.makeInserter(lsanDBTable);
            this.parse50LSanReport(filepath, lsanDBInserter);
        } else {
            MemLSanTable lsanDBTable = new MemLSanTable();
            DBInserter lsanDBInserter = this.makeInserter(lsanDBTable);
            this.parseUpTo41LSanReport(filepath, lsanDBInserter);
        }
    }

    /*
     * Exception decompiling
     */
    protected void parseUpTo41LSanReport(String filepath, DBInserter lsanDBInserter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void parse50LSanReport(String filepath, DBInserter lsanDBInserter) {
        ArrayList<List<Object>> lsanDataList;
        block15: {
            Scanner scanner = null;
            lsanDataList = new ArrayList<List<Object>>();
            String parsingErrorMsg = "Failed to parse file: " + filepath;
            try {
                scanner = new Scanner((InputStream)new FileInputStream(new File(filepath)), StandardCharsets.US_ASCII.name());
                int pid = 0;
                int leak_count = 0;
                long leak_size = 0L;
                ArrayList<String> row = null;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty()) continue;
                    LSanMatcher matcher = new LSanMatcher(line);
                    if (matcher.header_line.find()) {
                        Logger.debug((Object)"header line");
                        pid = Integer.parseInt(matcher.header_line.group(1));
                        Logger.debug((Object)("PID is " + pid));
                        continue;
                    }
                    if (matcher.leak_line.find()) {
                        leak_size = Long.parseLong(matcher.leak_line.group(1));
                        leak_count = Integer.parseInt(matcher.leak_line.group(2));
                        row = new ArrayList<String>();
                        row.add((String)((Object)Integer.valueOf(pid)));
                        row.add((String)((Object)Long.valueOf(leak_size)));
                        row.add((String)((Object)Integer.valueOf(leak_count)));
                        row.add(String.valueOf(line.trim()) + "\n");
                        lsanDataList.add(row);
                        continue;
                    }
                    if (matcher.callstack_line.find()) {
                        row.set(3, row.get(3) + line.trim() + "\n");
                        continue;
                    }
                    if (!matcher.start_line.find()) continue;
                    Logger.debug((Object)"start line");
                }
                if (!lsanDataList.isEmpty()) {
                    lsanDBInserter.pushData(lsanDataList);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.warning((Object)("File was not found: " + filepath));
                if (scanner != null) {
                    scanner.close();
                }
                break block15;
            }
            catch (NumberFormatException e) {
                try {
                    Logger.error((Object)(String.valueOf(parsingErrorMsg) + CommonConstants.NEW_LINE + e.getMessage()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            if (scanner != null) {
                scanner.close();
            }
        }
        this.constructLeaksList(lsanDataList);
    }

    @Override
    protected void makeData(LogPackage pack) {
    }

    private class LSanMatcher {
        private Pattern start_pattern = Pattern.compile("====+");
        private Pattern header_pattern = Pattern.compile("==([0-9]+)==ERROR: LeakSanitizer: detected memory leaks");
        private Pattern leak_pattern = Pattern.compile("Direct leak of ([0-9]+) byte\\(s\\) in ([0-9]+) object\\(s\\) allocated from:");
        private Pattern callstack_pattern = Pattern.compile("#([0-9]+) 0x([0-9a-f]+) \\(.*\\)");
        Matcher start_line;
        Matcher header_line;
        Matcher leak_line;
        Matcher callstack_line;

        public LSanMatcher(String line) {
            this.start_line = this.start_pattern.matcher(line);
            this.header_line = this.header_pattern.matcher(line);
            this.leak_line = this.leak_pattern.matcher(line);
            this.callstack_line = this.callstack_pattern.matcher(line);
        }
    }
}

