/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemFreeDBTable
extends DBTable {
    public static final String TABLENAME = "MEM_FREE_DB";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemFreeDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.MESSAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FREE_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_LIBRARY_ID.name, "NOT NULL", "INTEGER"));
        this.setPrimaryKey(COLUMN.SEQUENCE_NUMBER.index, COLUMN.PID.index, COLUMN.FREE_TIME.index);
        this.addIndex(COLUMN.ALLOCATED_ADDRESS.index, COLUMN.FREE_TIME.index, COLUMN.PID.index);
        this.addIndex(COLUMN.PID.index, COLUMN.CALLER_LIBRARY_ID.index, COLUMN.ALLOCATED_ADDRESS.index, COLUMN.FREE_TIME.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.MESSAGE_ID.index));
                prep.setLong(4, (Long)rowData.get(COLUMN.FREE_TIME.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.ALLOCATED_ADDRESS.index));
                prep.setInt(6, (Integer)rowData.get(COLUMN.CALLER_LIBRARY_ID.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    protected void postProcess(List<List<Object>> data) {
        data.clear();
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getLong(4));
            row.add(rs.getLong(5));
            row.add(rs.getInt(6));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public List<List<Object>> selectBasicColumns(String where) {
        return this.selectData(this.getBasicColumns(), where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getLong(1));
                    row.add(rs.getInt(2));
                    row.add(rs.getLong(3));
                    row.add(rs.getLong(4));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }

    private List<String> getBasicColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        BASIC_COLUMN[] bASIC_COLUMNArray = BASIC_COLUMN.values();
        int n = bASIC_COLUMNArray.length;
        int n2 = 0;
        while (n2 < n) {
            BASIC_COLUMN col = bASIC_COLUMNArray[n2];
            columns.add(col.name);
            ++n2;
        }
        return columns;
    }

    static enum BASIC_COLUMN {
        SEQUENCE_NUMBER(0, COLUMN.SEQUENCE_NUMBER),
        PID(1, COLUMN.PID),
        FREE_TIME(2, COLUMN.FREE_TIME),
        ALLOCATED_ADDRESS(3, COLUMN.ALLOCATED_ADDRESS);

        public final int index;
        public final String name;

        private BASIC_COLUMN(int index, COLUMN col) {
            this.index = index;
            this.name = col.name;
        }
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        MESSAGE_ID(2, "MESSAGE_ID"),
        FREE_TIME(3, "FREE_TIME"),
        ALLOCATED_ADDRESS(4, "ALLOCATED_ADDRESS"),
        CALLER_LIBRARY_ID(5, "CALLER_LIBRARY_ID");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

