/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkAPIDBManager;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataMaker;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkSeriesDBManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSelectionType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSeriesType;

public class NetworkDataManager
extends PageDataManager {
    public static final int MAX_CHART_TIME = 999999999;
    public static final double NETWORK_SERIES_TYPE_HEAP_MEMORY_KB = 0.3;
    public static final double CHART_TYPE_HEAP_MEMORY_KB = 23.0;
    public static final double MAX_NETWORK_HEAP_MEMORY_KB = 5000.0;
    public static final double ONE_CHART_HEAP_MEMORY_KB = 0.3;
    public static final double ONE_ACCESS_SERIES_HEAP_MEMORY_KB = 0.3;
    private static NetworkDataManager instance = new NetworkDataManager();
    private int rid = 0;
    private NetworkDataMaker networkDataMaker = null;
    private NetworkSeriesDBManager seriesDBManager = null;
    private NetworkAPIDBManager apiDBManager = null;
    private List<NetworkAPIType> selectedTableAPIList = null;
    private LinkedHashMap<String, String> checkStatusSeries = new LinkedHashMap();
    private List<NetworkSeriesType> seriesList = new ArrayList<NetworkSeriesType>();
    private LinkedHashMap<Long, Integer> parentChartIndexOfSeq = new LinkedHashMap();
    private LinkedHashMap<Long, Integer> childChartIndexOfSeq = new LinkedHashMap();
    NetworkSelectionType selectedData = null;
    private int chartCount = 0;
    private int accessSeriesSize = 0;

    public NetworkDataManager() {
        this.networkDataMaker = new NetworkDataMaker();
        this.apiDBManager = new NetworkAPIDBManager();
        this.seriesDBManager = new NetworkSeriesDBManager();
    }

    public static NetworkDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.selectedTableAPIList = null;
        this.seriesList = new ArrayList<NetworkSeriesType>();
        this.checkStatusSeries = new LinkedHashMap();
        this.parentChartIndexOfSeq = new LinkedHashMap();
        this.childChartIndexOfSeq = new LinkedHashMap();
        this.chartCount = 0;
        this.accessSeriesSize = 0;
        this.networkDataMaker.clear();
        this.rid = 0;
    }

    public LinkedHashMap<String, String> getCheckStatusSeries() {
        return this.checkStatusSeries;
    }

    public NetworkAPIDBManager getAPIDBManger() {
        return this.apiDBManager;
    }

    public void setStartSeriesData(NetworkSeriesType seriesType) {
        if (seriesType.getAPIType() == 0) {
            ++this.chartCount;
        } else {
            ++this.accessSeriesSize;
        }
        this.checkHeapMemory();
        this.seriesList.add(seriesType);
    }

    public void setEndSeriesData(String address, String fd, long endTime, int apiType) {
        int i = 0;
        while (i < this.seriesList.size()) {
            NetworkSeriesType seriesType = this.seriesList.get(i);
            if (seriesType.getDestinationAddress().equals(address) && seriesType.getFdValue().equals(fd) && seriesType.getAPIType() == apiType && seriesType.getEndTime() < 0L) {
                this.seriesList.get(i).setEndTime(endTime);
                this.insertToSeriesDB(seriesType);
                break;
            }
            ++i;
        }
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        if (this.seriesList == null || this.seriesDBManager == null) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            NetworkSeriesType seriesType = this.seriesList.get(i);
            if (seriesType.getEndTime() < 0L) {
                this.insertToSeriesDB(seriesType);
            }
            ++i;
        }
    }

    private void insertToSeriesDB(NetworkSeriesType insertData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertData.setRid(this.rid++);
        insertDataList.add(insertData.getDBInsertData());
        this.seriesDBManager.insertData(insertDataList);
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        if (this.seriesList == null) {
            return;
        }
        if (this.seriesList.size() == 0) {
            this.seriesList = this.seriesDBManager.select(0.0, 9.99999999E8);
        }
    }

    public List<NetworkSeriesType> getSeriesList() {
        return this.seriesList;
    }

    public void setSeriesList(List<NetworkSeriesType> seriesList) {
        this.seriesList = seriesList;
    }

    public List<NetworkAPIType> getSelectedTableAPIList() {
        return this.selectedTableAPIList;
    }

    public void setSelectedTableAPIList(List<NetworkAPIType> selectedTableAPIList) {
        this.selectedTableAPIList = selectedTableAPIList;
    }

    public void setSelectedData(NetworkSelectionType selectedData) {
        this.selectedData = selectedData;
    }

    public NetworkSelectionType getSelectedData() {
        return this.selectedData;
    }

    private void checkHeapMemory() {
        double useHeapMemory = (double)this.chartCount * 0.3 + (double)this.accessSeriesSize * 0.3;
        if (5000.0 < useHeapMemory) {
            DALimit.stopTraceAndOpenWarningDialog();
        }
    }

    public int getParentIndexOfSeq(long seq) {
        Integer chartIndex = this.parentChartIndexOfSeq.get(seq);
        if (chartIndex != null) {
            return chartIndex;
        }
        return 0;
    }

    public void setParentIndexOfSeq(long seq, int paretnChartIndex) {
        Integer chartIndex = this.parentChartIndexOfSeq.get(seq);
        if (chartIndex == null) {
            this.parentChartIndexOfSeq.put(seq, paretnChartIndex);
        }
    }

    public int getChildIndexOfSeq(long seq) {
        Integer chartIndex = this.childChartIndexOfSeq.get(seq);
        if (chartIndex != null) {
            return chartIndex;
        }
        return 0;
    }

    public void setChildIndexOfSeq(long seq, int childChartIndex) {
        Integer chartIndex = this.childChartIndexOfSeq.get(seq);
        if (chartIndex == null) {
            this.childChartIndexOfSeq.put(seq, childChartIndex);
        }
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs logs = pack.getLogs(273);
        if (logs != null && logs.getRawLogs().size() != 0) {
            List<LogData> inputs = logs.getLogs();
            this.networkDataMaker.makeData(inputs);
        }
    }
}

