/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart.listener;

import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class GLChartMouseListener
extends MouseAdapter
implements MouseMoveListener {
    protected DAPopupMenu menu;
    protected DATimeline timeline;
    protected double baseTime = -1.0;
    protected static final int SELECTION_MARKER_INDEX = 0;
    protected int clickChartIndex = 0;

    public GLChartMouseListener(DAPopupMenu menu, DATimeline timeline) {
        this.menu = menu;
        this.timeline = timeline;
    }

    public void mouseUp(MouseEvent e) {
        double markerEndTime;
        double markerStartTime;
        if (e.button == 3) {
            return;
        }
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotIntervalMarker intervalMarker = IntervalManager.INSTANCE.getSelectionMarker();
        double eventTime = plot.getXFromXPixel(e.x);
        int frame = (int)eventTime;
        if (intervalMarker.getStartVal() >= eventTime) {
            markerStartTime = eventTime;
            markerEndTime = intervalMarker.getEndVal();
        } else {
            markerStartTime = intervalMarker.getStartVal();
            markerEndTime = eventTime;
        }
        double toolbarTime = (double)Toolbar.INSTANCE.getTime() / 1000000.0;
        if (markerStartTime < 0.0) {
            markerStartTime = 0.0;
        } else if (markerStartTime > toolbarTime) {
            markerStartTime = toolbarTime;
        }
        if (markerEndTime > toolbarTime) {
            markerEndTime = toolbarTime;
        } else if (markerEndTime < 0.0) {
            markerEndTime = 0.0;
        }
        if (markerEndTime <= plot.getVisibleEndX()) {
            IntervalManager.INSTANCE.setSelectionMarkerInterval(markerStartTime, markerEndTime);
        } else {
            IntervalManager.INSTANCE.setSelectionMarkerInterval(markerStartTime, plot.getVisibleEndX());
        }
        this.sendSelectionTimes(intervalMarker.getStartVal(), intervalMarker.getEndVal());
        this.timeline.setDetailFrame(frame);
    }

    public void mouseMove(MouseEvent e) {
        DAChartPlotTooltip tooltip;
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        if ((e.stateMask & 0x80000) != 0) {
            double eventTime = plot.getXFromXPixel(e.x);
            if (this.baseTime > eventTime) {
                IntervalManager.INSTANCE.setSelectionMarkerInterval(eventTime, this.baseTime);
            } else {
                IntervalManager.INSTANCE.setSelectionMarkerInterval(this.baseTime, eventTime);
            }
        }
        if ((tooltip = plot.getTooltip()) == null) {
            return;
        }
        double newStartVal = this.getTooltipStartX(plot, chart.getSeriesList(), e.x);
        if (CommonUtil.isDoublesEquals((double)tooltip.getStartVal(), (double)newStartVal)) {
            tooltip.setStartVal(newStartVal);
        }
        this.timeline.setDetailTime(plot.getXFromXPixel(e.x));
        this.timeline.setDetailTimePosition(e.x);
        this.timeline.setDrawDetailTime(true);
        this.timeline.redraw();
    }

    private void sendSelectionTimes(double start, double end) {
        long endTime = (long)(end * 1000000.0);
        long startTime = (long)(start * 1000000.0);
        if (endTime < startTime) {
            long temp = startTime;
            startTime = endTime;
            endTime = temp;
        }
        if (startTime < 0L) {
            startTime = 0L;
        }
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(TimelinePage.timelineViewID, startTime, endTime, null, null));
    }

    private double getTooltipStartX(DAChartPlot plot, List<DAChartSeries> seriesList, int x) {
        double ret = -1.0;
        int i = 0;
        while (i < seriesList.size()) {
            DAChartSeries series = seriesList.get(i);
            int index = series.getPrevIndexByXvalue(plot.getXFromXPixel(x));
            if (-1 == index) {
                if (plot instanceof DAUIEventChartPlot) {
                    break;
                }
            } else {
                double startVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
                if (ret < startVal) {
                    ret = startVal;
                }
                if (plot instanceof DAUIEventChartPlot) break;
            }
            ++i;
        }
        return ret;
    }
}

