/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLRedundantDataType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLRedundantDBTableManager
extends DBTable {
    private static final String TABLE_NAME = "GL_REDUNDANT";
    public static final String CALL_COUNT = "CALL_COUNT";
    public static final String ELAPSED_TIME = "ELAPSED_TIME";
    public static final String API_ID = "API_ID";
    public static final String ARGUMENT = "ARGUMENT";
    public static final int TABLE_CALL_COUNT_INDEX = 0;
    public static final int TABLE_ELAPSED_TIME_INDEX = 1;
    public static final int TABLE_API_ID_INDEX = 2;
    public static final int TABLE_ARGUMENT_INDEX = 3;
    private static final String SELECT_QUERY = "select CALL_COUNT,ELAPSED_TIME,API_ID,ARGUMENT from GL_REDUNDANT";

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public GLRedundantDBTableManager() {
        this.addColumn(new DBColumn(CALL_COUNT, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ELAPSED_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(API_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ARGUMENT, "NOT NULL", "VARCHAR(1024)"));
    }

    public void insertRedundantData(List<GLRedundantDataType> data) {
        ArrayList<List<Object>> insertList = new ArrayList<List<Object>>();
        for (GLRedundantDataType rowData : data) {
            ArrayList<Object> objectList = new ArrayList<Object>();
            objectList.add(rowData.getCallCount());
            objectList.add(rowData.getElapsedTime());
            objectList.add(rowData.getApiID());
            objectList.add(rowData.getArgs());
            insertList.add(objectList);
        }
        this.insertData(insertList);
    }

    public List<GLRedundantDataType> select() {
        ResultSet rs = SqlConnectionManager.executeQueryRS(SELECT_QUERY);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLRedundantDataType> textureList = new ArrayList<GLRedundantDataType>();
        try {
            while (rs.next()) {
                GLRedundantDataType data = new GLRedundantDataType();
                data.setCallCount(rs.getInt(1));
                data.setElapsedTime(rs.getLong(2));
                data.setApiID(rs.getInt(3));
                data.setArgs(rs.getString(4));
                textureList.add(data);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return textureList;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, ((Integer)rowData.get(0)).intValue());
                prep.setDouble(2, ((Long)rowData.get(1)).longValue());
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setString(4, (String)rowData.get(3));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

