/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLStateHistoryDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_HISTORY";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String CONTEXT_DB_INDEX = "RENDER_STATE_ID";
    public static final String CHANGE_SEQ = "CHANGE_SEQUENCE_NUMBER";
    public static final String FRAME_RATE_INDEX = "FRAME_RATE_INDEX";
    public static final String FRAME_TIME_INDEX = "FRAME_TIME_INDEX";
    public static final int TABLE_CONTEXT_ID_INDEX = 0;
    public static final int TABLE_CONTEXT_DB_INDEX_INDEX = 1;
    public static final int TABLE_CHANGE_SEQ_INDEX = 2;
    public static final int TABLE_FRAME_RATE_INDEX_INDEX = 3;
    public static final int TABLE_FRAME_TIME_INDEX_INDEX = 4;
    private static final String SELECT_LAST_CHANGED_SEQ_QUERY = "select CONTEXT_ID,RENDER_STATE_ID,CHANGE_SEQUENCE_NUMBER,FRAME_RATE_INDEX,FRAME_TIME_INDEX from GL_HISTORY where CONTEXT_ID = '%s'and RENDER_STATE_ID = '%s'and CHANGE_SEQUENCE_NUMBER = (select MAX(CHANGE_SEQUENCE_NUMBER) from GL_HISTORY where CONTEXT_ID = '%s' and RENDER_STATE_ID = '%s' and CHANGE_SEQUENCE_NUMBER < '%s')";
    private static final String SELECT_NEXT_CHANGED_SEQ_QUERY = "select CONTEXT_ID,RENDER_STATE_ID,CHANGE_SEQUENCE_NUMBER,FRAME_RATE_INDEX,FRAME_TIME_INDEX from GL_HISTORY where CONTEXT_ID = '%s'and RENDER_STATE_ID = '%s'and CHANGE_SEQUENCE_NUMBER = (select MIN(CHANGE_SEQUENCE_NUMBER) from GL_HISTORY where CONTEXT_ID = '%s' and RENDER_STATE_ID = '%s' and CHANGE_SEQUENCE_NUMBER > '%s')";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLStateHistoryDBTableManager() {
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(CONTEXT_DB_INDEX, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(CHANGE_SEQ, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(FRAME_RATE_INDEX, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(FRAME_TIME_INDEX, "NOT NULL", "INTEGER"));
        this.addIndex(0, 1, 2);
    }

    public void insertData(long contextId, int stateIndex, long seq, int frameRateIndex, int frameTimeIndex) {
        ArrayList<List<Object>> insertList = new ArrayList<List<Object>>();
        ArrayList<Number> objectList = new ArrayList<Number>();
        objectList.add(contextId);
        objectList.add(stateIndex);
        objectList.add(seq);
        objectList.add(frameRateIndex);
        objectList.add(frameTimeIndex);
        insertList.add(objectList);
        this.insertData(insertList);
    }

    public List<Object> selectLastChangedSeq(long contextId, int stateIndex, long seq) {
        String query = String.format(SELECT_LAST_CHANGED_SEQ_QUERY, contextId, stateIndex, contextId, stateIndex, seq);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        return this.getDBData(rs);
    }

    private List<Object> getDBData(ResultSet rs) {
        ArrayList<Object> returnValue = new ArrayList<Object>();
        try {
            while (rs.next()) {
                returnValue.add(rs.getLong(1));
                returnValue.add(rs.getInt(2));
                returnValue.add(rs.getLong(3));
                returnValue.add(rs.getInt(4));
                returnValue.add(rs.getInt(5));
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    public List<Object> selectNextChangedSeq(long contextId, int stateIndex, long seq) {
        String query = String.format(SELECT_NEXT_CHANGED_SEQ_QUERY, contextId, stateIndex, contextId, stateIndex, seq);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        return this.getDBData(rs);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setLong(3, (Long)rowData.get(2));
                prep.setInt(4, (Integer)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

