/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.toggle;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomFeatureToggleButtonRenderer
extends DACustomButtonRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        if (attr.getDrawType() == 0) {
            Image image = attr.getImage(state);
            if (image == null) {
                return;
            }
            gc.drawImage(image, rect.x, rect.y);
            this.drawButtonText(gc, rect, attr, state);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr);
            this.drawButtonToggleImage(gc, rect, state, attr);
        }
    }

    @Override
    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        if (attr.getDrawType() == 1) {
            gc.setBackground(attr.getColor(state));
            gc.fillRectangle(rect);
        } else {
            int index = state * 2;
            gc.setForeground(attr.getColor(index));
            gc.setBackground(attr.getColor(index + 1));
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.drawButtonText(gc, r, attr, state);
        Color c = gc.getForeground();
        if (attr.getOutlineColor(state) != null) {
            gc.setForeground(attr.getOutlineColor(state));
            gc.drawRectangle(r);
        }
        Rectangle ir = new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        if (attr.getOutlineInColor(state) != null) {
            gc.setForeground(attr.getOutlineInColor(state));
            gc.drawRectangle(ir);
        }
        gc.setForeground(c);
    }

    private void drawButtonToggleImage(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        Point p = null;
        Image img = null;
        int x = 0;
        int y = 0;
        if (attr.getButtonImagePoint() != null) {
            p = attr.getButtonImagePoint();
            x = p.x;
            y = p.y;
        }
        img = state == 0 ? attr.getButtonImage(0) : (state == 2 ? attr.getButtonImage(2) : (state == 1 || state == 4 || state == 5 || state == 6 ? attr.getButtonImage(4) : attr.getButtonImage(3)));
        gc.drawImage(img, x, y);
    }

    @Override
    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        String text = null;
        Font font = null;
        Point p = null;
        int x = 0;
        int y = 0;
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        font = attr.getFont();
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(textRect), 0);
            attr.setFont(font);
        }
        gc.setFont(font);
        if (attr.getFontColor(state) != null) {
            gc.setForeground(attr.getFontColor(state));
        } else {
            gc.setForeground(ColorResources.BLACK);
        }
        text = attr.getText();
        if (text != null) {
            font = attr.getTitleFont();
            gc.setFont(font);
            if (attr.getFontPoint() != null) {
                p = attr.getFontPoint();
                x = p.x;
                y = p.y;
            } else {
                x = 120;
                y = 30;
            }
            if (attr.getCapitalize()) {
                char[] charArr = text.toCharArray();
                charArr[0] = (char)(charArr[0] - 32);
                text = new String(charArr);
            }
            if (!text.contains(CommonConstants.NEW_LINE)) {
                gc.drawString(text, x, y, true);
            } else {
                int startY = y;
                String[] splitedText = text.split(CommonConstants.NEW_LINE);
                int linelength = splitedText.length;
                Point[] pText = new Point[linelength];
                int i = 0;
                while (i < linelength) {
                    pText[i] = gc.textExtent(splitedText[i]);
                    gc.drawText(splitedText[i], x, startY, true);
                    startY += pText[i].y;
                    ++i;
                }
            }
        }
        ArrayList<String> dispText = new ArrayList<String>();
        text = attr.getDescription();
        if (text != null) {
            font = attr.getDescFont();
            gc.setFont(font);
            x = 120;
            y = 49;
            int pixSize = gc.getFontMetrics().getAverageCharWidth();
            int index = 0;
            int prevIndex = -1;
            int beginIndex = 0;
            int endIndex = 0;
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char Char = cArray[n2];
                ++index;
                if (Char == ' ') {
                    if ((index - beginIndex) * pixSize > textRect.width - 140) {
                        endIndex = prevIndex;
                        dispText.add(text.substring(beginIndex, endIndex));
                        beginIndex = endIndex + 1;
                        prevIndex = index - 1;
                    } else {
                        prevIndex = index - 1;
                    }
                }
                ++n2;
            }
            if (index > endIndex) {
                dispText.add(text.substring(beginIndex, index));
            }
            int yPos = 0;
            for (String inputText : dispText) {
                gc.drawText(inputText, x, y + yPos, 66);
                yPos += gc.getFontMetrics().getHeight();
            }
        }
        if ((text = attr.getPage()) != null) {
            font = attr.getPageFont();
            gc.setFont(font);
            x = 120;
            y = dispText.size() < 2 ? 78 : (dispText.size() < 3 ? 93 : 100);
            gc.drawText(text, x, y, 6);
        }
    }
}

