/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;

public class DADialog {
    private static final int gapwithbuttons = -8;
    private static final int wideWidth = 480;
    private static final int miniWidth = 320;
    private static final int defaultHeifght = 220;
    private static final int button_top = 18;
    private Shell parent = null;
    private Shell shell = null;
    private Button okButton = null;
    private Button exportButton = null;
    private Button yesButton = null;
    private Button noButton = null;
    private Button saveButton = null;
    private Button discardButton = null;
    private String message = null;
    private boolean returnType = false;
    private String titleText = WidgetLabels.TITLE;
    private int width = 0;
    private int height = 0;
    private Image iconImage = ImageResources.DYNANMIC_ANALYZER_ICON;
    private DIALOGTYPE dialogtype = DIALOGTYPE.ERROR;

    public DADialog(Shell parent, DIALOGTYPE type, int style, int width, int height) {
        this.width = width;
        this.height = height;
        this.parent = parent;
        this.dialogtype = type;
    }

    public DADialog(Shell parent, DIALOGTYPE type, int style) {
        this.parent = parent;
        this.dialogtype = type;
        this.width = 480;
        this.height = 220;
        if (type == DIALOGTYPE.SAVE || type == DIALOGTYPE.YES_NO) {
            this.width = 320;
        }
    }

    public boolean setDialog() {
        this.returnType = false;
        this.shell = new Shell(this.parent, 67680);
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - this.width) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - this.height) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(this.width, this.height);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(this.titleText);
        this.shell.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        Composite base = new Composite((Composite)this.shell, 0);
        base.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 1);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = 128;
        base.setLayoutData((Object)formData);
        base.setBackground(ColorResources.WHITE);
        Label icon = new Label(base, 0x40000000);
        icon.setBackground(ColorResources.WHITE);
        icon.setImage(this.iconImage);
        formData = new FormData();
        formData.top = new FormAttachment(0, 50);
        formData.left = new FormAttachment(0, 35);
        formData.height = 28;
        formData.width = 28;
        icon.setLayoutData((Object)formData);
        if (this.message.contains("\n")) {
            Label boldMessage = new Label(base, 0x40000040);
            boldMessage.setText(this.message.substring(0, this.message.indexOf("\n")));
            boldMessage.setBackground(ColorResources.WHITE);
            boldMessage.setAlignment(16384);
            boldMessage.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
            boldMessage.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
            formData = new FormData();
            formData.top = new FormAttachment(0, 45);
            formData.left = new FormAttachment((Control)icon, 15);
            formData.right = new FormAttachment(95, 0);
            boldMessage.setLayoutData((Object)formData);
            Label normalMessage = new Label(base, 0x40000040);
            normalMessage.setText(this.message.substring(this.message.indexOf("\n") + 1));
            normalMessage.setBackground(ColorResources.WHITE);
            normalMessage.setAlignment(16384);
            normalMessage.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
            normalMessage.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
            formData = new FormData();
            formData.top = new FormAttachment((Control)boldMessage, 1);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment((Control)icon, 15);
            formData.right = new FormAttachment(95, 0);
            normalMessage.setLayoutData((Object)formData);
        } else {
            Label strMessage = new Label(base, 0x40000040);
            strMessage.setText(this.message);
            strMessage.setBackground(ColorResources.WHITE);
            strMessage.setAlignment(16384);
            strMessage.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
            strMessage.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
            formData = new FormData();
            formData.top = new FormAttachment(0, 55);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment((Control)icon, 15);
            formData.right = new FormAttachment(95, 0);
            strMessage.setLayoutData((Object)formData);
        }
        Composite middlLinebase = new Composite((Composite)this.shell, 0);
        middlLinebase.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.top = new FormAttachment((Control)base, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = 1;
        middlLinebase.setLayoutData((Object)formData);
        middlLinebase.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BUTTON_BACKGROUND);
        formData = new FormData();
        formData.top = new FormAttachment((Control)middlLinebase, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)formData);
        if (this.dialogtype == DIALOGTYPE.ERROR_WITH_EXPORT) {
            this.addOKButton(buttonComp);
            this.addExportButton(buttonComp);
        } else if (this.dialogtype == DIALOGTYPE.ERROR) {
            this.addOKButton(buttonComp);
        } else if (this.dialogtype == DIALOGTYPE.YES_NO) {
            this.addYesNoButton(buttonComp);
        } else if (this.dialogtype == DIALOGTYPE.SAVE) {
            this.addSaveButton(buttonComp);
        }
        return this.returnType;
    }

    private void addOKButton(Composite buttonComp) {
        this.okButton = new Button(buttonComp, 0);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DADialog.this.returnType = true;
                DADialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.okButton.setText(WidgetLabels.OK);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 18);
        okData.right = new FormAttachment(100, -20);
        okData.width = 86;
        okData.height = 24;
        this.okButton.setLayoutData((Object)okData);
    }

    private void addExportButton(Composite buttonComp) {
        this.exportButton = new Button(buttonComp, 0);
        this.exportButton.setText(WidgetLabels.EXPORT_LOGS);
        this.exportButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData exportData = new FormData();
        exportData.top = new FormAttachment(0, 18);
        exportData.left = new FormAttachment(0, 20);
        exportData.width = 116;
        exportData.height = 24;
        this.exportButton.setLayoutData((Object)exportData);
    }

    private void addYesNoButton(Composite buttonComp) {
        this.noButton = new Button(buttonComp, 0);
        this.noButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.noButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DADialog.this.returnType = false;
                DADialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.noButton.setText(WidgetLabels.NO);
        FormData fromdata = new FormData();
        fromdata.top = new FormAttachment(0, 18);
        fromdata.right = new FormAttachment(100, 20);
        fromdata.width = 86;
        fromdata.height = 24;
        this.noButton.setLayoutData((Object)fromdata);
        this.yesButton = new Button(buttonComp, 0);
        this.yesButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.yesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DADialog.this.returnType = true;
                DADialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.yesButton.setText(WidgetLabels.YES);
        fromdata = new FormData();
        fromdata.top = new FormAttachment(0, 18);
        fromdata.right = new FormAttachment((Control)this.noButton, -8);
        fromdata.width = 86;
        fromdata.height = 24;
        this.yesButton.setLayoutData((Object)fromdata);
        this.yesButton.setFocus();
    }

    private void addSaveButton(Composite buttonComp) {
        this.discardButton = new Button(buttonComp, 0);
        this.discardButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.discardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DADialog.this.returnType = true;
                DADialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.discardButton.setText(WidgetLabels.DISCARD);
        FormData fromdata = new FormData();
        fromdata.top = new FormAttachment(0, 18);
        fromdata.right = new FormAttachment(100, -20);
        fromdata.width = 86;
        fromdata.height = 24;
        this.discardButton.setLayoutData((Object)fromdata);
        this.saveButton = new Button(buttonComp, 0);
        this.saveButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DADialog.this.returnType = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.saveButton.setText(WidgetLabels.SAVE);
        fromdata = new FormData();
        fromdata.top = new FormAttachment(0, 18);
        fromdata.right = new FormAttachment((Control)this.discardButton, -8);
        fromdata.width = 86;
        fromdata.height = 24;
        this.saveButton.setLayoutData((Object)fromdata);
        this.saveButton.setFocus();
    }

    public void open() {
        this.shell.open();
        Display display = Display.getCurrent();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.shell.dispose();
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setIcon(Image img) {
        this.iconImage = img;
    }

    public void setTitleText(String title) {
        this.titleText = title;
    }

    public boolean getResult() {
        return this.returnType;
    }

    public Button getExportButton() {
        return this.exportButton;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public static enum DIALOGTYPE {
        ERROR_WITH_EXPORT,
        ERROR,
        SAVE,
        YES_NO;

    }
}

