/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DAAbstractText;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextCallbackEvent;

public class DASearchTextBox
extends DAAbstractText {
    private Composite composite = null;
    private Image searchImage = ImageResources.SEARCH_IMAGE;
    DATextCallbackEvent searcher = null;

    public DASearchTextBox(Composite parent, int style) {
        this.composite = new Composite(parent, 0x20000000);
        this.composite.setLayout((Layout)new FormLayout());
        this.composite.setBackground(ColorResources.WHITE);
        this.text = new Text(this.composite, style);
        this.text.setBackground(ColorResources.WHITE);
        this.text.setForeground(ColorResources.TEXT_BOX_MESSAGE);
        this.text.setFont(FontResources.getDADefaultFont());
        this.text.setMessage("Search");
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail != 256) {
                    if (DASearchTextBox.this.searcher != null) {
                        DASearchTextBox.this.searcher.searchforText(DASearchTextBox.this.text.getText());
                    } else {
                        Logger.debug((Object)"searcher is null, register CallbackEvent!!");
                    }
                }
            }
        });
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(DASearchTextBox.this.boaderColor);
                e.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                e.gc.drawImage(DASearchTextBox.this.searchImage, 4, 2);
            }
        });
        this.text.addListener(6, this.textMouseListener);
        this.text.addListener(7, this.textMouseListener);
        this.text.addListener(3, this.textMouseListener);
        this.text.addListener(4, this.textMouseListener);
        this.text.addListener(32, this.textMouseListener);
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                DASearchTextBox.this.boaderColor = ColorResources.TEXT_NORMAL_COLOR;
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setLayoutData(FormData data) {
        this.composite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, -1);
        data.left = new FormAttachment(0, 26);
        data.right = new FormAttachment(100, -1);
        this.text.setLayoutData((Object)data);
        this.composite.layout();
    }

    @Override
    void redraw() {
        this.composite.redraw();
    }

    public void setSearchImage(Image image) {
        this.searchImage = image;
    }

    public void registerCallbackEvent(DATextCallbackEvent event) {
        this.searcher = event;
    }
}

