/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileAccessorDB
extends DBTable {
    public static final String TABLENAME = "FILE_ACCESSOR";
    private static final String DBTYPE_FILEPATH = "VARCHAR(4096)";
    private static final String selectAll = FileAccessorDB.selectAll();
    private static final String SELECT_QUERY = "select " + selectAll + " from " + "FILE_ACCESSOR";

    public FileAccessorDB() {
        this.addColumn(new DBColumn(COLUMN.ACCESSOR_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FILE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FILE_PATH.name, "NOT NULL", DBTYPE_FILEPATH));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.IS_TARGET.name, "NOT NULL", "BOOLEAN"));
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public List<FileAccessor> executeQueryRS(String query) {
        ArrayList<FileAccessor> resultData = new ArrayList<FileAccessor>();
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        FileAccessor accessor = this.getDataFromResultSet(rs);
                        if (accessor == null) continue;
                        resultData.add(accessor);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return resultData;
    }

    public FileAccessor getDataFromResultSet(ResultSet rs) {
        FileAccessor accessor = null;
        try {
            accessor = new FileAccessor(rs.getInt(COLUMN.ACCESSOR_ID.index), rs.getInt(COLUMN.FILE_ID.index), rs.getString(COLUMN.FILE_PATH.index), rs.getInt(COLUMN.PID.index), rs.getInt(COLUMN.TID.index), rs.getBoolean(COLUMN.IS_TARGET.index));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return accessor;
    }

    public void insert(FileAccessor insertData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertDataList.add(insertData.getDBData());
        this.insertData(insertDataList);
    }

    public List<FileAccessor> select() {
        String query = String.format(SELECT_QUERY, new Object[0]);
        ArrayList<FileAccessor> accessorList = new ArrayList();
        accessorList = this.executeQueryRS(query);
        return accessorList;
    }

    public static String selectAll() {
        StringBuffer selectAllColumn = new StringBuffer();
        selectAllColumn.append(COLUMN.ACCESSOR_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.FILE_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.FILE_PATH.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.PID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.TID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.IS_TARGET.name);
        return selectAllColumn.toString();
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setString(3, (String)rowData.get(2));
                prep.setLong(4, ((Integer)rowData.get(3)).intValue());
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setBoolean(6, (Boolean)rowData.get(5));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        ACCESSOR_ID(1, "ACCESSOR_ID"),
        FILE_ID(2, "FILE_ID"),
        FILE_PATH(3, "FILE_PATH"),
        PID(4, "PID"),
        TID(5, "TID"),
        IS_TARGET(6, "IS_TARGET");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

