/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.manager;

import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.ui.file.data.FileAccessDB;
import org.tizen.dynamicanalyzer.ui.file.data.FileAccessorDB;
import org.tizen.dynamicanalyzer.ui.file.data.FileApiDB;
import org.tizen.dynamicanalyzer.ui.file.data.FileStatusDB;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataMaker;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccess;
import org.tizen.dynamicanalyzer.ui.file.model.FileSelectedData;

public class FileDataManager
extends PageDataManager {
    private static FileDataManager instance = new FileDataManager();
    private FileDataMaker dataMaker = new FileDataMaker();
    private FileAccessDB accessDB = null;
    private FileApiDB apiDB = null;
    private FileStatusDB statusDB = null;
    private FileAccessorDB accessorDB = null;
    private DBInserter accessDBInserter = null;
    private DBInserter accessorDBInserter = null;
    private DBInserter satatusDBInserter = null;
    private DBInserter apiDBInserter = null;
    private FileSelectedData selectedData = null;

    private FileDataManager() {
        this.initDB();
    }

    public static FileDataManager getInstance() {
        return instance;
    }

    public void initDB() {
        this.accessDB = new FileAccessDB();
        this.apiDB = new FileApiDB();
        this.statusDB = new FileStatusDB();
        this.accessorDB = new FileAccessorDB();
        this.apiDBInserter = this.makeInserter(this.apiDB);
        this.accessDBInserter = this.makeInserter(this.accessDB);
        this.accessorDBInserter = this.makeInserter(this.accessorDB);
        this.satatusDBInserter = this.makeInserter(this.statusDB);
    }

    public void clear() {
        this.selectedData = null;
    }

    public FileAccessDB getAccessDB() {
        return this.accessDB;
    }

    public FileApiDB getApiDB() {
        return this.apiDB;
    }

    public FileStatusDB getStatusDB() {
        return this.statusDB;
    }

    public FileAccessorDB getAccessorDB() {
        return this.accessorDB;
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        List<FileAccess> accessList = this.dataMaker.getFileAccessList();
        if (accessList != null && accessList.size() > 0) {
            int i = 0;
            while (i < accessList.size()) {
                FileAccess access = accessList.get(i);
                if (access.getEndTime() < 0L) {
                    this.accessDB.insert(access);
                }
                ++i;
            }
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        if (this.dataMaker.getFileAccessList().size() == 0) {
            this.dataMaker.setFileAccessList(this.accessDB.select());
        }
        if (this.dataMaker.getFileStatusList().size() == 0) {
            this.dataMaker.setFileStatusList(this.statusDB.select());
        }
        if (this.dataMaker.getFileApiList().size() == 0) {
            this.dataMaker.setFileApiList(this.apiDB.select());
        }
        if (this.dataMaker.getFileAccessorList().size() == 0) {
            this.dataMaker.setFileAccessorList(this.accessorDB.select());
        }
    }

    public FileDataMaker getFileChartDataMaker() {
        return this.dataMaker;
    }

    public void setSelectedData(FileSelectedData selectedData) {
        this.selectedData = selectedData;
    }

    public FileSelectedData getSelectedData() {
        return this.selectedData;
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.dataMaker.makeData(pack);
    }

    public DBInserter getApiDBInserter() {
        return this.apiDBInserter;
    }

    public DBInserter getAccessDBInserter() {
        return this.accessDBInserter;
    }

    public void setAccessDBInserter(DBInserter accessDBInserter) {
        this.accessDBInserter = accessDBInserter;
    }

    public DBInserter getAccessorDBInserter() {
        return this.accessorDBInserter;
    }

    public DBInserter getSatatusDBInserter() {
        return this.satatusDBInserter;
    }
}

