/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.type;

import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class GLConstantDefine {
    private static HashMap<Integer, String> constantMap = null;

    static {
        constantMap = new HashMap();
        constantMap.put(256, "GL_DEPTH_BUFFER_BIT");
        constantMap.put(1024, "GL_STENCIL_BUFFER_BIT");
        constantMap.put(16384, "GL_COLOR_BUFFER_BIT");
        constantMap.put(1280, "GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT");
        constantMap.put(16640, "GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT");
        constantMap.put(17408, "GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT");
        constantMap.put(17664, "GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT");
        constantMap.put(768, "GL_SRC_COLOR");
        constantMap.put(769, "GL_ONE_MINUS_SRC_COLOR");
        constantMap.put(770, "GL_SRC_ALPHA");
        constantMap.put(771, "GL_ONE_MINUS_SRC_ALPHA");
        constantMap.put(772, "GL_DST_ALPHA");
        constantMap.put(773, "GL_ONE_MINUS_DST_ALPHA");
        constantMap.put(774, "GL_DST_COLOR");
        constantMap.put(775, "GL_ONE_MINUS_DST_COLOR");
        constantMap.put(776, "GL_SRC_ALPHA_SATURATE");
        constantMap.put(32774, "GL_FUNC_ADD");
        constantMap.put(32777, "GL_BLEND_EQUATION");
        constantMap.put(32777, "GL_BLEND_EQUATION_RGB");
        constantMap.put(34877, "GL_BLEND_EQUATION_ALPHA");
        constantMap.put(32778, "GL_FUNC_SUBTRACT");
        constantMap.put(32779, "GL_FUNC_REVERSE_SUBTRACT");
        constantMap.put(32968, "GL_BLEND_DST_RGB");
        constantMap.put(32969, "GL_BLEND_SRC_RGB");
        constantMap.put(32970, "GL_BLEND_DST_ALPHA");
        constantMap.put(32971, "GL_BLEND_SRC_ALPHA");
        constantMap.put(32769, "GL_CONSTANT_COLOR");
        constantMap.put(32770, "GL_ONE_MINUS_CONSTANT_COLOR");
        constantMap.put(32771, "GL_CONSTANT_ALPHA");
        constantMap.put(32772, "GL_ONE_MINUS_CONSTANT_ALPHA");
        constantMap.put(32773, "GL_BLEND_COLOR");
        constantMap.put(34962, "GL_ARRAY_BUFFER");
        constantMap.put(34963, "GL_ELEMENT_ARRAY_BUFFER");
        constantMap.put(34964, "GL_ARRAY_BUFFER_BINDING");
        constantMap.put(34965, "GL_ELEMENT_ARRAY_BUFFER_BINDING");
        constantMap.put(35040, "GL_STREAM_DRAW");
        constantMap.put(35044, "GL_STATIC_DRAW");
        constantMap.put(35048, "GL_DYNAMIC_DRAW");
        constantMap.put(34660, "GL_BUFFER_SIZE");
        constantMap.put(34661, "GL_BUFFER_USAGE");
        constantMap.put(34342, "GL_CURRENT_VERTEX_ATTRIB");
        constantMap.put(1028, "GL_FRONT");
        constantMap.put(1029, "GL_BACK");
        constantMap.put(1032, "GL_FRONT_AND_BACK");
        constantMap.put(3553, "GL_TEXTURE_2D");
        constantMap.put(2884, "GL_CULL_FACE");
        constantMap.put(3042, "GL_BLEND");
        constantMap.put(3024, "GL_DITHER");
        constantMap.put(2960, "GL_STENCIL_TEST");
        constantMap.put(2929, "GL_DEPTH_TEST");
        constantMap.put(3089, "GL_SCISSOR_TEST");
        constantMap.put(32823, "GL_POLYGON_OFFSET_FILL");
        constantMap.put(32926, "GL_SAMPLE_ALPHA_TO_COVERAGE");
        constantMap.put(32928, "GL_SAMPLE_COVERAGE");
        constantMap.put(2304, "GL_CW");
        constantMap.put(2305, "GL_CW");
        constantMap.put(2849, "GL_LINE_WIDTH");
        constantMap.put(33901, "GL_ALIASED_POINT_SIZE_RANGE");
        constantMap.put(33902, "GL_ALIASED_LINE_WIDTH_RANGE");
        constantMap.put(2885, "GL_CULL_FACE_MODE");
        constantMap.put(2886, "GL_FRONT_FACE");
        constantMap.put(2928, "GL_DEPTH_RANGE");
        constantMap.put(2930, "GL_DEPTH_WRITEMASK");
        constantMap.put(2931, "GL_DEPTH_CLEAR_VALUE");
        constantMap.put(2932, "GL_DEPTH_FUNC");
        constantMap.put(2961, "GL_STENCIL_CLEAR_VALUE");
        constantMap.put(2962, "GL_STENCIL_FUNC");
        constantMap.put(2964, "GL_STENCIL_FAIL");
        constantMap.put(2965, "GL_STENCIL_PASS_DEPTH_FAIL");
        constantMap.put(2966, "GL_STENCIL_PASS_DEPTH_PASS");
        constantMap.put(2967, "GL_STENCIL_REF");
        constantMap.put(2963, "GL_STENCIL_VALUE_MASK");
        constantMap.put(2968, "GL_STENCIL_WRITEMASK");
        constantMap.put(34816, "GL_STENCIL_BACK_FUNC");
        constantMap.put(34817, "GL_STENCIL_BACK_FAIL");
        constantMap.put(34818, "GL_STENCIL_BACK_PASS_DEPTH_FAIL");
        constantMap.put(34819, "GL_STENCIL_BACK_PASS_DEPTH_PASS");
        constantMap.put(36003, "GL_STENCIL_BACK_REF");
        constantMap.put(36004, "GL_STENCIL_BACK_VALUE_MASK");
        constantMap.put(36005, "GL_STENCIL_BACK_WRITEMASK");
        constantMap.put(2978, "GL_VIEWPORT");
        constantMap.put(3088, "GL_SCISSOR_BOX");
        constantMap.put(3089, "GL_SCISSOR_TEST");
        constantMap.put(3106, "GL_COLOR_CLEAR_VALUE");
        constantMap.put(3107, "GL_COLOR_WRITEMASK");
        constantMap.put(3317, "GL_UNPACK_ALIGNMENT");
        constantMap.put(3333, "GL_PACK_ALIGNMENT");
        constantMap.put(3379, "GL_MAX_TEXTURE_SIZE");
        constantMap.put(3386, "GL_MAX_VIEWPORT_DIMS");
        constantMap.put(3408, "GL_SUBPIXEL_BITS");
        constantMap.put(3410, "GL_RED_BITS");
        constantMap.put(3411, "GL_GREEN_BITS");
        constantMap.put(3412, "GL_BLUE_BITS");
        constantMap.put(3413, "GL_ALPHA_BITS");
        constantMap.put(3414, "GL_DEPTH_BITS");
        constantMap.put(3415, "GL_STENCIL_BITS");
        constantMap.put(10752, "GL_POLYGON_OFFSET_UNITS");
        constantMap.put(32823, "GL_POLYGON_OFFSET_FILL");
        constantMap.put(32824, "GL_POLYGON_OFFSET_FACTOR");
        constantMap.put(32873, "GL_TEXTURE_BINDING_2D");
        constantMap.put(32936, "GL_SAMPLE_BUFFERS");
        constantMap.put(32937, "GL_SAMPLES");
        constantMap.put(32938, "GL_SAMPLE_COVERAGE_VALUE");
        constantMap.put(32939, "GL_SAMPLE_COVERAGE_INVERT");
        constantMap.put(34466, "GL_NUM_COMPRESSED_TEXTURE_FORMATS");
        constantMap.put(34467, "GL_COMPRESSED_TEXTURE_FORMATS");
        constantMap.put(4352, "GL_DONT_CARE");
        constantMap.put(4353, "GL_FASTEST");
        constantMap.put(4354, "GL_NICEST");
        constantMap.put(33170, "GL_GENERATE_MIPMAP_HINT");
        constantMap.put(5120, "GL_BYTE");
        constantMap.put(5121, "GL_UNSIGNED_BYTE");
        constantMap.put(5122, "GL_SHORT");
        constantMap.put(5123, "GL_UNSIGNED_SHORT");
        constantMap.put(5124, "GL_INT");
        constantMap.put(5125, "GL_UNSIGNED_INT");
        constantMap.put(5126, "GL_FLOAT");
        constantMap.put(5132, "GL_FIXED");
        constantMap.put(6402, "GL_DEPTH_COMPONENT");
        constantMap.put(6406, "GL_ALPHA");
        constantMap.put(6407, "GL_RGB");
        constantMap.put(6408, "GL_RGBA");
        constantMap.put(6409, "GL_LUMINANCE");
        constantMap.put(6410, "GL_LUMINANCE_ALPHA");
        constantMap.put(32819, "GL_UNSIGNED_SHORT_4_4_4_4");
        constantMap.put(32820, "GL_UNSIGNED_SHORT_5_5_5_1");
        constantMap.put(33635, "GL_UNSIGNED_SHORT_5_6_5");
        constantMap.put(35632, "GL_FRAGMENT_SHADER");
        constantMap.put(35633, "GL_VERTEX_SHADER");
        constantMap.put(34921, "GL_MAX_VERTEX_ATTRIBS");
        constantMap.put(36347, "GL_MAX_VERTEX_UNIFORM_VECTORS");
        constantMap.put(36348, "GL_MAX_VARYING_VECTORS");
        constantMap.put(35661, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS");
        constantMap.put(35660, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS");
        constantMap.put(34930, "GL_MAX_TEXTURE_IMAGE_UNITS");
        constantMap.put(36349, "GL_MAX_FRAGMENT_UNIFORM_VECTORS");
        constantMap.put(35663, "GL_SHADER_TYPE");
        constantMap.put(35712, "GL_DELETE_STATUS");
        constantMap.put(35714, "GL_LINK_STATUS");
        constantMap.put(35715, "GL_VALIDATE_STATUS");
        constantMap.put(35717, "GL_ATTACHED_SHADERS");
        constantMap.put(35718, "GL_ACTIVE_UNIFORMS");
        constantMap.put(35719, "GL_ACTIVE_UNIFORM_MAX_LENGTH");
        constantMap.put(35721, "GL_ACTIVE_ATTRIBUTES");
        constantMap.put(35722, "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH");
        constantMap.put(35724, "GL_SHADING_LANGUAGE_VERSION");
        constantMap.put(35725, "GL_CURRENT_PROGRAM");
        constantMap.put(512, "GL_NEVER");
        constantMap.put(513, "GL_LESS");
        constantMap.put(514, "GL_EQUAL");
        constantMap.put(515, "GL_LEQUAL");
        constantMap.put(516, "GL_GREATER");
        constantMap.put(517, "GL_NOTEQUAL");
        constantMap.put(518, "GL_GEQUAL");
        constantMap.put(519, "GL_ALWAYS");
        constantMap.put(7680, "GL_KEEP");
        constantMap.put(7681, "GL_REPLACE");
        constantMap.put(7682, "GL_INCR");
        constantMap.put(7683, "GL_DECR");
        constantMap.put(5386, "GL_INVERT");
        constantMap.put(34055, "GL_INCR_WRAP");
        constantMap.put(34056, "GL_DECR_WRAP");
        constantMap.put(7936, "GL_VENDOR");
        constantMap.put(7937, "GL_RENDERER");
        constantMap.put(7938, "GL_VERSION");
        constantMap.put(7939, "GL_EXTENSIONS");
        constantMap.put(9728, "GL_NEAREST");
        constantMap.put(9729, "GL_LINEAR");
        constantMap.put(9984, "GL_NEAREST_MIPMAP_NEAREST");
        constantMap.put(9985, "GL_LINEAR_MIPMAP_NEAREST");
        constantMap.put(9986, "GL_NEAREST_MIPMAP_LINEAR");
        constantMap.put(9987, "GL_LINEAR_MIPMAP_LINEAR");
        constantMap.put(10240, "GL_TEXTURE_MAG_FILTER");
        constantMap.put(10241, "GL_TEXTURE_MIN_FILTER");
        constantMap.put(10242, "GL_TEXTURE_WRAP_S");
        constantMap.put(10243, "GL_TEXTURE_WRAP_T");
        constantMap.put(5890, "GL_TEXTURE");
        constantMap.put(34067, "GL_TEXTURE_CUBE_MAP");
        constantMap.put(34068, "GL_TEXTURE_BINDING_CUBE_MAP");
        constantMap.put(34069, "GL_TEXTURE_CUBE_MAP_POSITIVE_X");
        constantMap.put(34070, "GL_TEXTURE_CUBE_MAP_NEGATIVE_X");
        constantMap.put(34071, "GL_TEXTURE_CUBE_MAP_POSITIVE_Y");
        constantMap.put(34072, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y");
        constantMap.put(34073, "GL_TEXTURE_CUBE_MAP_POSITIVE_Z");
        constantMap.put(34074, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z");
        constantMap.put(34076, "GL_MAX_CUBE_MAP_TEXTURE_SIZE");
        constantMap.put(33984, "GL_TEXTURE0");
        constantMap.put(33985, "GL_TEXTURE1");
        constantMap.put(33986, "GL_TEXTURE2");
        constantMap.put(33987, "GL_TEXTURE3");
        constantMap.put(33988, "GL_TEXTURE4");
        constantMap.put(33989, "GL_TEXTURE5");
        constantMap.put(33990, "GL_TEXTURE6");
        constantMap.put(33991, "GL_TEXTURE7");
        constantMap.put(33992, "GL_TEXTURE8");
        constantMap.put(33993, "GL_TEXTURE9");
        constantMap.put(33994, "GL_TEXTURE10");
        constantMap.put(33995, "GL_TEXTURE11");
        constantMap.put(33996, "GL_TEXTURE12");
        constantMap.put(33997, "GL_TEXTURE13");
        constantMap.put(33998, "GL_TEXTURE14");
        constantMap.put(33999, "GL_TEXTURE15");
        constantMap.put(34000, "GL_TEXTURE16");
        constantMap.put(34001, "GL_TEXTURE17");
        constantMap.put(34002, "GL_TEXTURE18");
        constantMap.put(34003, "GL_TEXTURE19");
        constantMap.put(34004, "GL_TEXTURE20");
        constantMap.put(34005, "GL_TEXTURE21");
        constantMap.put(34006, "GL_TEXTURE22");
        constantMap.put(34007, "GL_TEXTURE23");
        constantMap.put(34008, "GL_TEXTURE24");
        constantMap.put(34009, "GL_TEXTURE25");
        constantMap.put(34010, "GL_TEXTURE26");
        constantMap.put(34011, "GL_TEXTURE27");
        constantMap.put(34012, "GL_TEXTURE28");
        constantMap.put(34013, "GL_TEXTURE29");
        constantMap.put(34014, "GL_TEXTURE30");
        constantMap.put(34015, "GL_TEXTURE31");
        constantMap.put(34016, "GL_ACTIVE_TEXTURE");
        constantMap.put(10497, "GL_REPEAT");
        constantMap.put(33071, "GL_CLAMP_TO_EDGE");
        constantMap.put(33648, "GL_MIRRORED_REPEAT");
        constantMap.put(35664, "GL_FLOAT_VEC2");
        constantMap.put(35665, "GL_FLOAT_VEC3");
        constantMap.put(35666, "GL_FLOAT_VEC4");
        constantMap.put(35667, "GL_INT_VEC2");
        constantMap.put(35668, "GL_INT_VEC3");
        constantMap.put(35669, "GL_INT_VEC4");
        constantMap.put(35670, "GL_BOOL");
        constantMap.put(35671, "GL_BOOL_VEC2");
        constantMap.put(35672, "GL_BOOL_VEC3");
        constantMap.put(35673, "GL_BOOL_VEC4");
        constantMap.put(35674, "GL_FLOAT_MAT2");
        constantMap.put(35675, "GL_FLOAT_MAT3");
        constantMap.put(35676, "GL_FLOAT_MAT4");
        constantMap.put(35678, "GL_SAMPLER_2D");
        constantMap.put(35680, "GL_SAMPLER_CUBE");
        constantMap.put(34338, "GL_VERTEX_ATTRIB_ARRAY_ENABLED");
        constantMap.put(34339, "GL_VERTEX_ATTRIB_ARRAY_SIZE");
        constantMap.put(34340, "GL_VERTEX_ATTRIB_ARRAY_STRIDE");
        constantMap.put(34341, "GL_VERTEX_ATTRIB_ARRAY_TYPE");
        constantMap.put(34922, "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED");
        constantMap.put(34373, "GL_VERTEX_ATTRIB_ARRAY_POINTER");
        constantMap.put(34975, "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING");
        constantMap.put(35738, "GL_IMPLEMENTATION_COLOR_READ_TYPE");
        constantMap.put(35739, "GL_IMPLEMENTATION_COLOR_READ_FORMAT");
        constantMap.put(35713, "GL_COMPILE_STATUS");
        constantMap.put(35716, "GL_INFO_LOG_LENGTH");
        constantMap.put(35720, "GL_SHADER_SOURCE_LENGTH");
        constantMap.put(36346, "GL_SHADER_COMPILER");
        constantMap.put(36195, "GL_PLATFORM_BINARY");
        constantMap.put(36344, "GL_SHADER_BINARY_FORMATS");
        constantMap.put(36345, "GL_NUM_SHADER_BINARY_FORMATS");
        constantMap.put(36336, "GL_LOW_FLOAT");
        constantMap.put(36337, "GL_MEDIUM_FLOAT");
        constantMap.put(36338, "GL_HIGH_FLOAT");
        constantMap.put(36339, "GL_LOW_INT");
        constantMap.put(36340, "GL_MEDIUM_INT");
        constantMap.put(36341, "GL_HIGH_INT");
        constantMap.put(36160, "GL_FRAMEBUFFER");
        constantMap.put(36161, "GL_RENDERBUFFER");
        constantMap.put(32854, "GL_RGBA4");
        constantMap.put(32855, "GL_RGB5_A1");
        constantMap.put(36194, "GL_RGB565");
        constantMap.put(33189, "GL_DEPTH_COMPONENT16");
        constantMap.put(6401, "GL_STENCIL_INDEX");
        constantMap.put(36168, "GL_STENCIL_INDEX8");
        constantMap.put(36162, "GL_RENDERBUFFER_WIDTH");
        constantMap.put(36163, "GL_RENDERBUFFER_HEIGHT");
        constantMap.put(36164, "GL_RENDERBUFFER_INTERNAL_FORMAT");
        constantMap.put(36176, "GL_RENDERBUFFER_RED_SIZE");
        constantMap.put(36177, "GL_RENDERBUFFER_GREEN_SIZE");
        constantMap.put(36178, "GL_RENDERBUFFER_BLUE_SIZE");
        constantMap.put(36179, "GL_RENDERBUFFER_ALPHA_SIZE");
        constantMap.put(36180, "GL_RENDERBUFFER_DEPTH_SIZE");
        constantMap.put(36181, "GL_RENDERBUFFER_STENCIL_SIZE");
        constantMap.put(36048, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE");
        constantMap.put(36049, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME");
        constantMap.put(36050, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL");
        constantMap.put(36051, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE");
        constantMap.put(36064, "GL_COLOR_ATTACHMENT0");
        constantMap.put(36096, "GL_DEPTH_ATTACHMENT");
        constantMap.put(36128, "GL_STENCIL_ATTACHMENT");
        constantMap.put(36053, "GL_FRAMEBUFFER_COMPLETE");
        constantMap.put(36054, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
        constantMap.put(36055, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
        constantMap.put(36057, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS");
        constantMap.put(36058, "GL_FRAMEBUFFER_INCOMPLETE_FORMATS");
        constantMap.put(36061, "GL_FRAMEBUFFER_UNSUPPORTED");
        constantMap.put(36006, "GL_FRAMEBUFFER_BINDING");
        constantMap.put(36007, "GL_RENDERBUFFER_BINDING");
        constantMap.put(34024, "GL_MAX_RENDERBUFFER_SIZE");
        constantMap.put(1286, "GL_INVALID_FRAMEBUFFER_OPERATION");
        constantMap.put(12288, "EGL_SUCCESS");
        constantMap.put(12289, "EGL_NOT_INITIALIZED");
        constantMap.put(12290, "EGL_BAD_ACCESS");
        constantMap.put(12291, "EGL_BAD_ALLOC");
        constantMap.put(12292, "EGL_BAD_ATTRIBUTE");
        constantMap.put(12293, "EGL_BAD_CONFIG");
        constantMap.put(12294, "EGL_BAD_CONTEXT");
        constantMap.put(12295, "EGL_BAD_CURRENT_SURFACE");
        constantMap.put(12296, "EGL_BAD_DISPLAY");
        constantMap.put(12297, "EGL_BAD_MATCH");
        constantMap.put(12298, "EGL_BAD_NATIVE_PIXMAP");
        constantMap.put(12299, "EGL_BAD_NATIVE_WINDOW");
        constantMap.put(12300, "EGL_BAD_PARAMETER");
        constantMap.put(12301, "EGL_BAD_SURFACE");
        constantMap.put(12302, "EGL_CONTEXT_LOST");
        constantMap.put(12320, "EGL_CONTEXT_LOST");
        constantMap.put(12321, "EGL_CONTEXT_LOST");
        constantMap.put(12322, "EGL_CONTEXT_LOST");
        constantMap.put(12323, "EGL_CONTEXT_LOST");
        constantMap.put(12324, "EGL_CONTEXT_LOST");
        constantMap.put(12325, "EGL_CONTEXT_LOST");
        constantMap.put(12326, "EGL_CONTEXT_LOST");
        constantMap.put(12327, "EGL_CONTEXT_LOST");
        constantMap.put(12328, "EGL_CONTEXT_LOST");
        constantMap.put(12329, "EGL_CONTEXT_LOST");
        constantMap.put(12330, "EGL_MAX_PBUFFER_HEIGHT");
        constantMap.put(12331, "EGL_MAX_PBUFFER_PIXELS");
        constantMap.put(12332, "EGL_MAX_PBUFFER_WIDTH");
        constantMap.put(12333, "EGL_NATIVE_RENDERABLE");
        constantMap.put(12334, "EGL_NATIVE_VISUAL_ID");
        constantMap.put(12335, "EGL_NATIVE_VISUAL_TYPE");
        constantMap.put(12336, "EGL_PRESERVED_RESOURCES");
        constantMap.put(12337, "EGL_SAMPLES");
        constantMap.put(12338, "EGL_SAMPLE_BUFFERS");
        constantMap.put(12339, "EGL_SURFACE_TYPE");
        constantMap.put(12340, "EGL_TRANSPARENT_TYPE");
        constantMap.put(12341, "EGL_TRANSPARENT_BLUE_VALUE");
        constantMap.put(12342, "EGL_TRANSPARENT_GREEN_VALUE");
        constantMap.put(12343, "EGL_TRANSPARENT_RED_VALUE");
        constantMap.put(12344, "EGL_NONE");
        constantMap.put(12345, "EGL_BIND_TO_TEXTURE_RGB");
        constantMap.put(12346, "EGL_BIND_TO_TEXTURE_RGBA");
        constantMap.put(12347, "EGL_MIN_SWAP_INTERVAL");
        constantMap.put(12348, "EGL_MAX_SWAP_INTERVAL");
        constantMap.put(12349, "EGL_LUMINANCE_SIZE");
        constantMap.put(12350, "EGL_ALPHA_MASK_SIZE");
        constantMap.put(12351, "EGL_COLOR_BUFFER_TYPE");
        constantMap.put(12352, "EGL_RENDERABLE_TYPE");
        constantMap.put(12353, "EGL_MATCH_NATIVE_PIXMAP");
        constantMap.put(12354, "EGL_CONFORMANT");
        constantMap.put(12368, "EGL_SLOW_CONFIG");
        constantMap.put(12369, "EGL_NON_CONFORMANT_CONFIG");
        constantMap.put(12370, "EGL_TRANSPARENT_RGB");
        constantMap.put(12430, "EGL_RGB_BUFFER");
        constantMap.put(12431, "EGL_LUMINANCE_BUFFER");
        constantMap.put(12380, "EGL_NO_TEXTURE");
        constantMap.put(12381, "EGL_TEXTURE_RGB");
        constantMap.put(12382, "EGL_TEXTURE_RGBA");
        constantMap.put(12383, "EGL_TEXTURE_2D");
        constantMap.put(12371, "EGL_VENDOR");
        constantMap.put(12372, "EGL_VERSION");
        constantMap.put(12373, "EGL_EXTENSIONS");
        constantMap.put(12429, "EGL_CLIENT_APIS");
        constantMap.put(12374, "EGL_HEIGHT");
        constantMap.put(12375, "EGL_WIDTH");
        constantMap.put(12376, "EGL_LARGEST_PBUFFER");
        constantMap.put(12416, "EGL_TEXTURE_FORMAT");
        constantMap.put(12417, "EGL_TEXTURE_TARGET");
        constantMap.put(12418, "EGL_MIPMAP_TEXTURE");
        constantMap.put(12419, "EGL_MIPMAP_LEVEL");
        constantMap.put(12422, "EGL_RENDER_BUFFER");
        constantMap.put(12423, "EGL_VG_COLORSPACE");
        constantMap.put(12424, "EGL_VG_ALPHA_FORMAT");
        constantMap.put(12432, "EGL_HORIZONTAL_RESOLUTION");
        constantMap.put(12433, "EGL_VERTICAL_RESOLUTION");
        constantMap.put(12434, "EGL_PIXEL_ASPECT_RATIO");
        constantMap.put(12435, "EGL_SWAP_BEHAVIOR");
        constantMap.put(12441, "EGL_MULTISAMPLE_RESOLVE");
        constantMap.put(12420, "EGL_BACK_BUFFER");
        constantMap.put(12421, "EGL_SINGLE_BUFFER");
        constantMap.put(12425, "EGL_VG_COLORSPACE_sRGB");
        constantMap.put(12426, "EGL_VG_COLORSPACE_LINEAR");
        constantMap.put(12427, "EGL_VG_ALPHA_FORMAT_NONPRE");
        constantMap.put(12428, "EGL_VG_ALPHA_FORMAT_PRE");
        constantMap.put(10000, "EGL_DISPLAY_SCALING");
        constantMap.put(12436, "EGL_BUFFER_PRESERVED");
        constantMap.put(12437, "EGL_BUFFER_DESTROYED");
        constantMap.put(12438, "EGL_OPENVG_IMAGE");
        constantMap.put(12439, "EGL_CONTEXT_CLIENT_TYPE");
        constantMap.put(12440, "EGL_CONTEXT_CLIENT_VERSION");
        constantMap.put(12442, "EGL_MULTISAMPLE_RESOLVE_DEFAULT");
        constantMap.put(12443, "EGL_MULTISAMPLE_RESOLVE_BOX");
        constantMap.put(12448, "EGL_OPENGL_ES_API");
        constantMap.put(12449, "EGL_OPENVG_API");
        constantMap.put(12450, "EGL_OPENGL_API");
        constantMap.put(12377, "EGL_DRAW");
        constantMap.put(12378, "EGL_READ");
        constantMap.put(12379, "EGL_CORE_NATIVE_ENGINE");
        constantMap.put(34962, "GL_ARRAY_BUFFER");
        constantMap.put(34963, "GL_ELEMENT_ARRAY_BUFFER");
    }

    public static int getConstantValue(String name) {
        for (Map.Entry<Integer, String> constant : constantMap.entrySet()) {
            if (!constant.getValue().equals(name)) continue;
            return constant.getKey();
        }
        return -1;
    }

    public static String getAPIConstantString(int value) {
        String result = GLConstantDefine.getConstantString(value);
        return result != null ? result : String.format("Unknown API (%d)", value);
    }

    public static String getConstantString(int value) {
        return constantMap.get(value);
    }

    public static String convertEnumValue(String arg, String splitChar, String[] removeChar) {
        if (arg.contains(splitChar)) {
            return GLConstantDefine.getEnumnValueForMultiArgCount(arg, splitChar, removeChar);
        }
        return GLConstantDefine.getEnumnValueForOneArgCount(arg);
    }

    private static String getEnumnValueForMultiArgCount(String arg, String splitChar, String[] removeChar) {
        StringBuffer returnValue = new StringBuffer();
        String[] argSplit = arg.split(splitChar);
        int i = 0;
        while (i < argSplit.length) {
            String value = GLConstantDefine.getValueRemoveChar(argSplit[i].trim(), removeChar);
            value = GLConstantDefine.getEnumnValueForOneArgCount(value);
            if (i == 0) {
                returnValue.append(value);
            } else {
                returnValue.append(",").append(" ").append(value);
            }
            ++i;
        }
        return returnValue.toString();
    }

    private static String getValueRemoveChar(String value, String[] removeChar) {
        if (removeChar == null) {
            return value;
        }
        int j = 0;
        while (j < removeChar.length) {
            if (value.contains(removeChar[j])) {
                value = value.replace(removeChar[j], "");
            }
            ++j;
        }
        return value;
    }

    private static String getEnumnValueForOneArgCount(String data) {
        StringBuffer returnValue = new StringBuffer();
        if (AnalyzerUtil.isInteger(data)) {
            returnValue.append(GLConstantDefine.getEnumnValue(data));
        } else if (AnalyzerUtil.isLong(data)) {
            returnValue.append("0x" + Long.toHexString(Long.parseLong(data.trim())));
        } else {
            returnValue.append(data);
        }
        return returnValue.toString();
    }

    private static String getEnumnValue(String arg) {
        String enumnValue = GLConstantDefine.getConstantString(Integer.parseInt(arg));
        if (enumnValue != null) {
            return enumnValue;
        }
        return arg;
    }
}

