/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageDataEvent;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncDataEvent;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class SyncChart {
    public static final int SYNC_PARENT_CHART = 0;
    public static final int SYNC_CHILD_CHART = 1;
    public static final int THREAD_CHART = 2;
    protected int chartType = -1;
    protected DAChartBoardItem item;
    protected DAChart chart;
    protected List<SyncChart> children = new ArrayList<SyncChart>();
    protected DAChartSeries syncAPISeries;
    protected DAChartSeries syncStateSeries;
    protected String chartName = "";
    protected int chartID = -1;
    protected int pId = -1;
    protected int tId = -1;

    public SyncChart(int chartId, DAChartBoardItem item, DAChart chart, int chartType) {
        this.setChartType(chartType);
        this.setChartID(chartId);
        this.setItem(item);
        this.setChart(chart);
    }

    public int getChartID() {
        return this.chartID;
    }

    public void setChartID(int chartID) {
        this.chartID = chartID;
    }

    public String getChartName() {
        return this.chartName.trim();
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public int getpId() {
        return this.pId;
    }

    public void setpId(int pId) {
        this.pId = pId;
    }

    public int gettId() {
        return this.tId;
    }

    public void settId(int tId) {
        this.tId = tId;
    }

    public boolean isParentChartRow() {
        return this.children.size() > 0;
    }

    public void pushChild(SyncChart data) {
        this.children.add(data);
    }

    public void setItem(DAChartBoardItem item) {
        this.item = item;
        this.setChart(item.getChart());
        if (this.chartType == 2) {
            return;
        }
        this.syncStateSeries = new DAChartSeries(ThreadPageLabels.THREAD_SYNC_CHART_SERIES_STATE, 13, ColorResources.WHITE, false);
        this.syncAPISeries = new DAChartSeries(ThreadPageLabels.THREAD_CHART_SERIES_API, 8, ColorResources.YELLOW);
        this.syncAPISeries.setSummarizeTooltipText(ThreadPageLabels.THREAD_TOOLTIP_APIS);
        this.chart.addSeries(this.syncStateSeries);
        this.chart.addSeries(this.syncAPISeries);
    }

    public DAChartBoardItem getItem() {
        return this.item;
    }

    public DAChart getChart() {
        return this.chart;
    }

    public void setChart(DAChart chart) {
        this.chart = chart;
    }

    public void clearSeries() {
        if (this.syncAPISeries != null) {
            this.syncAPISeries.clear();
        }
        if (this.syncStateSeries != null) {
            this.syncStateSeries.clear();
        }
    }

    public void updateSyncSeries(List<ThreadPageSyncDataEvent> eventList) {
        if (this.chartType == 2) {
            return;
        }
        for (ThreadPageSyncDataEvent syncEvent : eventList) {
            if (this.chartID != syncEvent.getSyncDataID()) continue;
            this.addSyncSeriesItem(syncEvent);
        }
        this.chart.redraw();
    }

    private void addSyncSeriesItem(ThreadPageSyncDataEvent syncEvent) {
        double startTime = syncEvent.getDoubleTime();
        double endTime = Formatter.longTimeToDoubleTime(syncEvent.getBlockEndTime());
        long errorNum = syncEvent.getErrorNum();
        switch (syncEvent.getApiType()) {
            case 0: 
            case 7: 
            case 8: 
            case 9: {
                if (this.chartType == 1) {
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.THREAD_GRAPH_LOCK_RELEASE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_UNUSED));
                }
                this.syncAPISeries.addSeriesItem(this.createAPIItem(syncEvent, errorNum));
                break;
            }
            case 1: 
            case 5: {
                this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_WAIT_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_WAITED));
                if (syncEvent.getBlockEndTime() != -1L) {
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(endTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_ACQUIRE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_USED));
                }
                this.syncAPISeries.addSeriesItem(this.createAPIItem(syncEvent, errorNum));
                break;
            }
            case 3: {
                if (syncEvent.getBlockEndTime() == -1L) {
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.THREAD_GRAPH_LOCK_RELEASE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_UNUSED));
                } else {
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_RELEASE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_UNUSED));
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(endTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_WAIT_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_WAITED));
                }
                this.syncAPISeries.addSeriesItem(this.createAPIItem(syncEvent, errorNum));
                break;
            }
            case 2: 
            case 6: {
                this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_ACQUIRE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_USED));
                if (syncEvent.getBlockEndTime() == -1L) break;
                this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(endTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_RELEASE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_UNUSED));
                break;
            }
            case 4: {
                this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_ACQUIRE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_USED));
                if (syncEvent.getBlockEndTime() != -1L) {
                    this.syncStateSeries.addSeriesItem(new DAChartSeriesItem(endTime, 2.0, ColorResources.THREAD_GRAPH_LOCK_RELEASE_COLOR, ThreadPageLabels.SYNC_CHART_ITEM_UNUSED));
                }
                this.syncAPISeries.addSeriesItem(this.createAPIItem(syncEvent, errorNum));
                break;
            }
            default: {
                return;
            }
        }
    }

    protected DAChartSeriesItem createAPIItem(ThreadPageDataEvent event, long errno) {
        DAChartSeriesItem apiItem = null;
        apiItem = 0L != errno ? new DAChartSeriesItem(event.getDoubleTime(), 0.0, ColorResources.RED, String.valueOf(event.getTooltipContent()) + ThreadPageLabels.SYNC_CHART_ITEM_FAILED) : new DAChartSeriesItem(event.getDoubleTime(), 0.0, ColorResources.YELLOW, event.getTooltipContent());
        return apiItem;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }
}

