/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadEventDBTable
extends DBTable {
    public static final String TABLENAME = "THREAD_EVENT";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.THREAD_DATA_ID.name) + "," + COLUMN.EVENT_TIME.name + "," + COLUMN.TID.name + "," + COLUMN.API_TYPE.name + "," + COLUMN.TOOLTIP.name + "," + COLUMN.ERROR_NUMBER.name + "," + COLUMN.EVENT_TYPE.name + "," + COLUMN.THREAD_TYPE.name + "," + COLUMN.CALLER_ID.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "THREAD_EVENT" + "  where " + COLUMN.EVENT_TIME.name + " BETWEEN %s and %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ThreadEventDBTable() {
        this.addColumn(new DBColumn(COLUMN.THREAD_DATA_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.EVENT_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.TOOLTIP.name, "", "VARCHAR", 256));
        this.addColumn(new DBColumn(COLUMN.ERROR_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.EVENT_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.THREAD_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALLER_ID.name, "", "INTEGER"));
        this.addIndex(COLUMN.THREAD_DATA_ID.index);
    }

    public List<List<Object>> getThreadEventFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.THREAD_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.THREAD_DATA_ID.index));
                prep.setLong(COLUMN.EVENT_TIME.index + 1, (Long)rowData.get(COLUMN.EVENT_TIME.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setByte(COLUMN.API_TYPE.index + 1, (Byte)rowData.get(COLUMN.API_TYPE.index));
                String tooltipStr = this.clipString((String)rowData.get(COLUMN.TOOLTIP.index), 256, rowData.get(COLUMN.EVENT_TIME.index).toString());
                prep.setString(COLUMN.TOOLTIP.index + 1, tooltipStr);
                prep.setLong(COLUMN.ERROR_NUMBER.index + 1, (Long)rowData.get(COLUMN.ERROR_NUMBER.index));
                prep.setByte(COLUMN.EVENT_TYPE.index + 1, (Byte)rowData.get(COLUMN.EVENT_TYPE.index));
                prep.setInt(COLUMN.THREAD_TYPE.index + 1, (Integer)rowData.get(COLUMN.THREAD_TYPE.index));
                prep.setInt(COLUMN.CALLER_ID.index + 1, (Integer)rowData.get(COLUMN.CALLER_ID.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(COLUMN.THREAD_DATA_ID.index + 1));
            row.add(rs.getLong(COLUMN.EVENT_TIME.index + 1));
            row.add(rs.getInt(COLUMN.TID.index + 1));
            row.add(rs.getByte(COLUMN.API_TYPE.index + 1));
            row.add(rs.getString(COLUMN.TOOLTIP.index + 1));
            row.add(rs.getLong(COLUMN.ERROR_NUMBER.index + 1));
            row.add(rs.getByte(COLUMN.EVENT_TYPE.index + 1));
            row.add(rs.getInt(COLUMN.THREAD_TYPE.index + 1));
            row.add(rs.getInt(COLUMN.CALLER_ID.index + 1));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        THREAD_DATA_ID(0, "THREAD_DATA_ID"),
        EVENT_TIME(1, "EVENT_TIME"),
        TID(2, "TID"),
        API_TYPE(3, "API_TYPE"),
        TOOLTIP(4, "TOOLTIP"),
        ERROR_NUMBER(5, "ERROR_NUMBER"),
        EVENT_TYPE(6, "EVENT_TYPE"),
        THREAD_TYPE(7, "THREAD_TYPE"),
        CALLER_ID(8, "CALLER_ID");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

