/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.ExpandToggleRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class DefaultColumnGroupHeaderRenderer
extends GridHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int imageSpacing = 3;
    private ExpandToggleRenderer toggleRenderer = new ExpandToggleRenderer();

    public void paint(GC gc, Object value) {
        GridColumnGroup group = (GridColumnGroup)((Object)value);
        if (this.isSelected()) {
            gc.setBackground(group.getParent().getCellHeaderSelectionBackground());
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width + 1, this.getBounds().height + 1);
        int x = this.leftMargin;
        if (group.getImage() != null) {
            gc.drawImage(group.getImage(), this.getBounds().x + x, this.getBounds().y + this.topMargin);
            x += group.getImage().getBounds().width + this.imageSpacing;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        if ((group.getStyle() & 2) != 0) {
            width -= this.toggleRenderer.getSize().x;
        }
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.drawString(TextUtils.getShortString(gc, group.getText(), width), this.getBounds().x + x, this.getBounds().y + this.topMargin);
        if ((group.getStyle() & 2) != 0) {
            this.toggleRenderer.setHover(this.isHover() && this.getHoverDetail().equals("toggle"));
            this.toggleRenderer.setExpanded(group.getExpanded());
            this.toggleRenderer.setBounds(this.getToggleBounds());
            this.toggleRenderer.paint(gc, null);
        }
        gc.setForeground(this.getDisplay().getSystemColor(17));
        gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
    }

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridColumnGroup group = (GridColumnGroup)((Object)value);
        int x = 0;
        x += this.leftMargin;
        x += gc.stringExtent((String)group.getText()).x + this.rightMargin;
        int y = 0;
        y += this.topMargin;
        y += gc.getFontMetrics().getHeight();
        y += this.bottomMargin;
        if (group.getImage() != null) {
            x += group.getImage().getBounds().width + this.imageSpacing;
            y = Math.max(y, this.topMargin + group.getImage().getBounds().height + this.bottomMargin);
        }
        return new Point(x, y);
    }

    public boolean notify(int event, Point point, Object value) {
        GridColumnGroup group = (GridColumnGroup)((Object)value);
        if ((group.getStyle() & 2) != 0) {
            if (event == 3) {
                if (this.getToggleBounds().contains(point)) {
                    group.setExpanded(!group.getExpanded());
                    if (group.getExpanded()) {
                        group.notifyListeners(17, new Event());
                    } else {
                        group.notifyListeners(18, new Event());
                    }
                    return true;
                }
            } else if (this.getToggleBounds().contains(point)) {
                this.setHoverDetail("toggle");
                return true;
            }
        }
        return false;
    }

    public Rectangle getToggleBounds() {
        int x = this.getBounds().x + this.getBounds().width - this.toggleRenderer.getBounds().width - this.rightMargin;
        int y = this.getBounds().y + (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2;
        return new Rectangle(x, y, this.toggleRenderer.getBounds().width, this.toggleRenderer.getBounds().height);
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.toggleRenderer.setDisplay(display);
    }

    public Rectangle getTextBounds(Object value, boolean preferred) {
        GridColumnGroup group = (GridColumnGroup)((Object)value);
        int x = this.leftMargin;
        if (group.getImage() != null) {
            x += group.getImage().getBounds().width + this.imageSpacing;
        }
        Rectangle bounds = new Rectangle(x, this.topMargin, 0, 0);
        GC gc = new GC((Drawable)group.getParent());
        gc.setFont(group.getParent().getFont());
        Point p = gc.stringExtent(group.getText());
        bounds.height = p.y;
        if (preferred) {
            bounds.width = p.x;
        } else {
            int width = this.getBounds().width - x - this.rightMargin;
            if ((group.getStyle() & 2) != 0) {
                width -= this.toggleRenderer.getSize().x;
            }
            bounds.width = width;
        }
        gc.dispose();
        return bounds;
    }
}

