/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

public class UnitConvertUtil {
    private static final int KILO = 1024;
    private static final float KILO_F = 1024.0f;
    private static final String UNITS = " KMGTPE";
    private static final char BYTE = 'B';

    public static String toByteUnitString(long bytes) {
        if (bytes < 1024L) {
            return String.valueOf(bytes) + " " + 'B';
        }
        int unitIndex = 0;
        while (bytes >= 0x100000L) {
            ++unitIndex;
            bytes >>= 10;
        }
        if (bytes >= 1024L) {
            ++unitIndex;
        }
        return String.format("%.2f %c%c", Float.valueOf((float)bytes / 1024.0f), Character.valueOf(UNITS.charAt(unitIndex)), Character.valueOf('B'));
    }

    public static String toByteUnitString(String value) {
        if (value == null) {
            return "N/A";
        }
        try {
            long bytes = Long.parseLong(value);
            return UnitConvertUtil.toByteUnitString(bytes);
        }
        catch (NumberFormatException numberFormatException) {
            return "N/A";
        }
    }
}

