/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import java.util.Comparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemCell;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;

public class DAChartBoardItem
extends Composite {
    private DAChartBoard parentBoard = null;
    private DAChartBoardItem parentItem = null;
    protected DAChartBoardItemCell itemCell = null;
    protected DAChartBoardItemList childItemList = null;
    protected double heightRatio;
    protected boolean childFolded = true;
    private boolean isHidden = false;
    private boolean isSelectable = true;
    public static final int DEFAULT_NAME_CELL_WIDTH = 190;
    private int depth = 0;
    private Object sortObj = null;
    private int height = 80;

    private void initWidget(String name, Image icon, int chartStyle) {
        this.heightRatio = this.getBoardItemHeightRatio();
        this.setLayout((Layout)new FormLayout());
        this.itemCell = new DAChartBoardItemCell(this, name, icon, chartStyle);
        this.itemCell.addExpandToggleButton();
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = (int)(this.heightRatio * (double)this.height);
        this.itemCell.setLayoutData(data);
        this.layout();
    }

    private void initWidget(String name, String fullName, Image icon, int chartStyle) {
        this.heightRatio = this.getBoardItemHeightRatio();
        this.setLayout((Layout)new FormLayout());
        this.itemCell = new DAChartBoardItemCell(this, name, icon, chartStyle);
        this.itemCell.setFullName(fullName);
        this.itemCell.addExpandToggleButton();
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = (int)(this.heightRatio * (double)this.height);
        this.itemCell.setLayoutData(data);
        this.layout();
    }

    public DAChartBoardItem(DAChartBoard parent, String itemName) {
        super((Composite)parent.getItemList(), 0);
        this.parentBoard = parent;
        this.height = parent.getItemHeight();
        this.initWidget(itemName, null, 0);
        this.parentBoard.registerItem(this);
    }

    public DAChartBoardItem(DAChartBoard parent, String itemName, String fullName) {
        super((Composite)parent.getItemList(), 0);
        this.parentBoard = parent;
        this.height = parent.getItemHeight();
        this.initWidget(itemName, fullName, null, 0);
        this.parentBoard.registerItem(this);
    }

    public DAChartBoardItem(DAChartBoardItem parent, String itemName, String fullName) {
        super((Composite)parent.getChildItemList(), 0);
        this.parentItem = parent;
        this.height = parent.getChartBoard().getItemHeight();
        this.depth = parent.getDepth() + 1;
        this.initWidget(itemName, fullName, null, 0);
        this.parentItem.registerItem(this);
    }

    public DAChartBoardItem(DAChartBoard parent, String itemName, Object o, Comparator c) {
        super((Composite)parent.getItemList(), 0);
        this.parentBoard = parent;
        this.height = parent.getItemHeight();
        this.sortObj = o;
        this.initWidget(itemName, null, 0);
        this.parentBoard.registerItem(this, c);
    }

    public DAChartBoardItem(DAChartBoard parent, String itemName, Image icon, int chartStyle) {
        super((Composite)parent.getItemList(), 0);
        this.parentBoard = parent;
        this.height = parent.getItemHeight();
        this.initWidget(itemName, icon, chartStyle);
        this.parentBoard.registerItem(this);
    }

    public DAChartBoardItem(DAChartBoardItem parent, String itemName) {
        super((Composite)parent.getChildItemList(), 0);
        this.parentItem = parent;
        this.height = parent.getChartBoard().getItemHeight();
        this.depth = parent.getDepth() + 1;
        this.initWidget(itemName, null, 0);
        this.parentItem.registerItem(this);
    }

    public DAChartBoardItem(DAChartBoardItem parent, String itemName, Object o, Comparator c) {
        super((Composite)parent.getChildItemList(), 0);
        this.parentItem = parent;
        this.height = parent.getChartBoard().getItemHeight();
        this.depth = parent.getDepth() + 1;
        this.sortObj = o;
        this.initWidget(itemName, null, 0);
        this.parentItem.registerItem(this, c);
    }

    public DAChartBoardItem(DAChartBoardItem parent, String itemName, Image icon, int chartStyle) {
        super((Composite)parent.getChildItemList(), 0);
        this.parentItem = parent;
        this.height = parent.getChartBoard().getItemHeight();
        this.depth = parent.getDepth() + 1;
        this.initWidget(itemName, icon, chartStyle);
        this.parentItem.registerItem(this);
    }

    double getBoardItemHeightRatio() {
        double itemHeightRatio = this.depth == 0 ? this.parentBoard.getItemHeightRatio() : this.parentItem.getBoardItemHeightRatio();
        return itemHeightRatio;
    }

    public void useExpand(boolean bUseExpand) {
        if (bUseExpand) {
            this.itemCell.addExpandToggleButton();
        } else {
            this.itemCell.removeExpandToggleButton();
        }
    }

    int getDepth() {
        return this.depth;
    }

    protected void callNotifyResizeChild() {
        if (this.depth == 0) {
            this.parentBoard.notifyResizeChild(this);
        } else {
            this.parentItem.notifyResizeChild(this);
        }
    }

    private void notifyResizeChild(DAChartBoardItem item) {
        this.childItemList.notifyResizeChild(item);
        FormData childDListata = (FormData)this.childItemList.getLayoutData();
        childDListata.height = this.childItemList.getListHeight();
        this.childItemList.setLayoutData(childDListata);
        this.callNotifyResizeChild();
    }

    protected void refreshItemCellHeight() {
        FormData data = (FormData)this.itemCell.getLayoutData();
        data.height = (int)(this.heightRatio * (double)this.height);
        this.itemCell.setLayoutData(data);
    }

    public void refreshItemHeight() {
        this.childItemList.setSize(this.childItemList.getBounds().width, this.childItemList.getListHeight());
        this.childItemList.layout();
        FormData data = (FormData)this.getLayoutData();
        data.height = this.getItemHeight();
        this.setLayoutData(data);
        this.refreshItemCellHeight();
    }

    private void registerItem(DAChartBoardItem child) {
        if (this.childItemList.getItemSize() == 0) {
            this.itemCell.addChildFoldToggleButton();
        }
        this.childItemList.registerItem(child);
        FormData childDListata = (FormData)this.childItemList.getLayoutData();
        childDListata.height = this.childItemList.getListHeight();
        this.childItemList.setLayoutData(childDListata);
        this.callNotifyResizeChild();
    }

    private void registerItem(DAChartBoardItem child, Comparator c) {
        if (this.childItemList.getItemSize() == 0) {
            this.itemCell.addChildFoldToggleButton();
        }
        this.childItemList.registerItem(child, c);
        FormData childDListata = (FormData)this.childItemList.getLayoutData();
        childDListata.height = this.childItemList.getListHeight();
        this.childItemList.setLayoutData(childDListata);
        this.callNotifyResizeChild();
    }

    void foldChild() {
        this.childFolded = true;
        FormData childListData = (FormData)this.childItemList.getLayoutData();
        childListData.height = 0;
        this.childItemList.setLayoutData(childListData);
        this.callNotifyResizeChild();
    }

    public void unFoldChild() {
        this.childFolded = false;
        FormData childListData = (FormData)this.childItemList.getLayoutData();
        childListData.height = this.childItemList.getListHeight();
        this.childItemList.setLayoutData(childListData);
        this.itemCell.setFoldButtonTrue();
        this.callNotifyResizeChild();
    }

    void callbackExpand(boolean bExpand) {
        this.heightRatio = bExpand ? 2.0 : this.getBoardItemHeightRatio();
        this.refreshItemCellHeight();
        this.callNotifyResizeChild();
    }

    void minimize() {
        this.heightRatio = 0.5;
        if (this.childItemList != null) {
            this.childItemList.minimize();
            if (!this.childFolded) {
                this.childItemList.layout();
            }
        }
        FormData data = (FormData)this.getLayoutData();
        data.height = this.getItemHeight();
        this.setLayoutData(data);
        this.itemCell.setExpandButtonNormal();
        this.refreshItemCellHeight();
    }

    void unMinimize() {
        FormData data;
        this.heightRatio = 1.0;
        if (this.childItemList != null) {
            this.childItemList.unMinimize();
            if (!this.childFolded) {
                data = (FormData)this.childItemList.getLayoutData();
                data.height = this.childItemList.getListHeight();
                this.childItemList.setLayoutData(data);
                this.childItemList.layout();
            }
        }
        data = (FormData)this.getLayoutData();
        data.height = this.getItemHeight();
        this.setLayoutData(data);
        this.itemCell.setExpandButtonNormal();
        this.refreshItemCellHeight();
    }

    private void NotifyCallbackSelection(DAChartBoardItem item) {
        if (this.parentBoard != null) {
            this.parentBoard.NotifyCallbackSelection(item);
            this.parentBoard.redraw();
        } else if (this.parentItem != null) {
            this.parentItem.NotifyCallbackSelection(item);
        } else {
            return;
        }
    }

    void callbackSelect(boolean bSelect) {
        if (bSelect) {
            this.NotifyCallbackSelection(this);
        } else {
            this.NotifyCallbackSelection(null);
        }
    }

    public DAChartBoardItemList getChildItemList() {
        if (this.childItemList == null) {
            this.childItemList = new DAChartBoardItemList(this);
            this.childItemList.setLayout((Layout)new FormLayout());
            FormData childDListata = new FormData();
            childDListata.left = new FormAttachment(0, 0);
            childDListata.top = new FormAttachment((Control)this.itemCell, 0);
            childDListata.right = new FormAttachment(100, 0);
            childDListata.height = 0;
            this.childItemList.setLayoutData(childDListata);
            this.layout();
        }
        return this.childItemList;
    }

    public DAChart getChart() {
        if (this.itemCell == null) {
            return null;
        }
        return this.itemCell.getChartCell();
    }

    public DAChartBoardItemCell getItemCell() {
        return this.itemCell;
    }

    void setChartAxis(double startX, double endX) {
        DAChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setAxisRangeX(startX, endX);
        chart.redraw();
        if (this.childItemList == null) {
            return;
        }
        this.childItemList.setChartAxis(startX, endX);
    }

    void setChartValidX(double endX) {
        DAChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setValidEndX(endX);
        chart.redraw();
        if (this.childItemList == null) {
            return;
        }
        this.childItemList.setChartValidX(endX);
    }

    void selectItem(boolean select) {
        this.itemCell.setSelectCell(select);
    }

    void clear() {
        if (this.childItemList != null) {
            this.childItemList.clear();
            this.childItemList.dispose();
        }
        this.itemCell.clear();
        this.itemCell.dispose();
    }

    void contentsClear() {
        if (this.childItemList != null) {
            this.childItemList.contentsClear();
        }
        this.itemCell.contentsClear();
    }

    boolean isHidden() {
        return this.isHidden;
    }

    void hide() {
        this.isHidden = true;
    }

    void show() {
        this.isHidden = false;
        FormData data = (FormData)this.itemCell.getLayoutData();
        data.height = this.getItemHeight();
        this.itemCell.setLayoutData(data);
        this.layout();
        this.refreshItemCellHeight();
        this.callNotifyResizeChild();
    }

    int getItemHeight() {
        if (this.isHidden) {
            return 0;
        }
        if (this.childFolded) {
            return (int)(this.heightRatio * (double)this.height);
        }
        if (this.childItemList != null) {
            return (int)(this.heightRatio * (double)this.height + (double)this.childItemList.getListHeight());
        }
        return 0;
    }

    Font getNameFont() {
        if (this.parentBoard != null) {
            return this.parentBoard.getNameFont();
        }
        if (this.parentItem != null) {
            return this.parentItem.getNameFont();
        }
        return null;
    }

    public DAChartBoard getChartBoard() {
        return this.parentBoard;
    }

    public Object getSortObject() {
        return this.sortObj;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
        if (!isSelectable) {
            this.itemCell.getChartCell().setDirty(true);
            this.selectItem(false);
        }
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setNameCellColor(Color topColor, Color bottomColor) {
        this.itemCell.setNameCellBGColor(topColor, bottomColor);
    }

    public void setHeight(int height) {
        this.height = height;
        this.refreshItemCellHeight();
        this.callNotifyResizeChild();
    }

    public int getHeight() {
        return this.height;
    }

    public void hideChildItems() {
        if (this.childItemList == null) {
            return;
        }
        int i = 0;
        while (i < this.childItemList.getItemSize()) {
            this.childItemList.hideItem(i);
            ++i;
        }
        this.callNotifyResizeChild();
    }

    public void showChildItems() {
        if (this.childItemList == null) {
            return;
        }
        int i = 0;
        while (i < this.childItemList.getItemSize()) {
            this.childItemList.showItem(i);
            ++i;
        }
        this.callNotifyResizeChild();
    }
}

