/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceContainerRelativeLocationConverter
implements IIndexLocationConverter {
    protected IWorkspaceRoot root;
    protected IPath fullPath;

    public ResourceContainerRelativeLocationConverter(IContainer container) {
        this.fullPath = container.getFullPath();
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        IFile member = this.root.getFile(this.fullPath.append(raw));
        return new IndexFileLocation(member.getLocationURI(), member.getFullPath().toString());
    }

    public String toInternalFormat(IIndexFileLocation location) {
        Path path;
        String sFullPath = location.getFullPath();
        if (sFullPath != null && this.fullPath.isPrefixOf((IPath)(path = new Path(sFullPath)))) {
            return path.removeFirstSegments(this.fullPath.segmentCount()).toString();
        }
        return null;
    }
}

