/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayModifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTNewExpression
extends ASTNode
implements ICPPASTNewExpression,
IASTAmbiguityParent {
    private IASTInitializerClause[] placement;
    private IASTTypeId typeId;
    private IASTInitializer initializer;
    private IASTImplicitName[] implicitNames = null;
    private boolean isGlobal;
    private boolean isNewTypeId;
    private IASTExpression[] cachedArraySizes;

    public CPPASTNewExpression() {
    }

    public CPPASTNewExpression(IASTInitializerClause[] placement, IASTInitializer initializer, IASTTypeId typeId) {
        this.setPlacementArguments(placement);
        this.setTypeId(typeId);
        this.setInitializer(initializer);
    }

    public CPPASTNewExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTNewExpression copy(IASTNode.CopyStyle style) {
        CPPASTNewExpression copy = new CPPASTNewExpression();
        copy.setIsGlobal(this.isGlobal);
        copy.setIsNewTypeId(this.isNewTypeId);
        if (this.placement != null) {
            IASTInitializerClause[] plcmt = new IASTInitializerClause[this.placement.length];
            int i = 0;
            while (i < this.placement.length) {
                plcmt[i] = this.placement[i].copy(style);
                ++i;
            }
            copy.setPlacementArguments(plcmt);
        }
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy(style));
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setIsGlobal(boolean value) {
        this.assertNotFrozen();
        this.isGlobal = value;
    }

    public IASTInitializerClause[] getPlacementArguments() {
        return this.placement;
    }

    public void setPlacementArguments(IASTInitializerClause[] args) {
        this.assertNotFrozen();
        this.placement = args;
        if (args != null) {
            IASTInitializerClause[] iASTInitializerClauseArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(NEW_PLACEMENT);
                ++n2;
            }
        }
    }

    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(IASTInitializer expression) {
        this.assertNotFrozen();
        this.initializer = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_INITIALIZER);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public boolean isNewTypeId() {
        return this.isNewTypeId;
    }

    public void setIsNewTypeId(boolean value) {
        this.assertNotFrozen();
        this.isNewTypeId = value;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction operatorFunction = CPPSemantics.findOverloadedOperator(this);
            if (operatorFunction == null || operatorFunction instanceof CPPImplicitFunction) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(operatorFunction.getNameCharArray(), (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(operatorFunction);
                operatorName.setOffsetAndLength(this.getOffset(), 3);
                this.implicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.implicitNames;
    }

    public boolean isArrayAllocation() {
        IASTDeclarator dtor;
        IASTTypeId typeId = this.getTypeId();
        if (typeId != null && (dtor = typeId.getAbstractDeclarator()) != null) {
            dtor = ASTQueries.findTypeRelevantDeclarator(dtor);
            return dtor instanceof IASTArrayDeclarator;
        }
        return false;
    }

    public boolean accept(ASTVisitor action) {
        int n;
        int n2;
        IASTNode[] iASTNodeArray;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            iASTNodeArray = this.getImplicitNames();
            n2 = iASTNodeArray.length;
            n = 0;
            while (n < n2) {
                IASTNode name = iASTNodeArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.placement != null) {
            iASTNodeArray = this.placement;
            n2 = this.placement.length;
            n = 0;
            while (n < n2) {
                IASTNode arg = iASTNodeArray[n];
                if (!arg.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.placement != null) {
            int i = 0;
            while (i < this.placement.length) {
                if (child == this.placement[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.placement[i] = (IASTExpression)other;
                }
                ++i;
            }
        }
    }

    public IType getExpressionType() {
        IType t = CPPVisitor.createType(this.getTypeId());
        if (t instanceof IArrayType) {
            t = ((IArrayType)t).getType();
        }
        return new CPPPointerType(t);
    }

    public boolean isLValue() {
        return false;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Deprecated
    public IASTExpression[] getNewTypeIdArrayExpressions() {
        if (this.cachedArraySizes == null) {
            IASTDeclarator dtor;
            if (this.typeId != null && (dtor = ASTQueries.findInnermostDeclarator(this.typeId.getAbstractDeclarator())) instanceof IASTArrayDeclarator) {
                IASTArrayDeclarator ad = (IASTArrayDeclarator)dtor;
                IASTArrayModifier[] ams = ad.getArrayModifiers();
                this.cachedArraySizes = new IASTExpression[ams.length];
                int i = 0;
                while (i < ams.length) {
                    IASTArrayModifier am = ams[i];
                    this.cachedArraySizes[i] = am.getConstantExpression();
                    ++i;
                }
                return this.cachedArraySizes;
            }
            this.cachedArraySizes = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return this.cachedArraySizes;
    }

    @Deprecated
    public void addNewTypeIdArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        Assert.isNotNull((Object)this.typeId);
        IASTDeclarator dtor = ASTQueries.findInnermostDeclarator(this.typeId.getAbstractDeclarator());
        if (!(dtor instanceof IASTArrayDeclarator)) {
            IASTPointerOperator[] ptrOps;
            Assert.isNotNull((Object)dtor);
            Assert.isTrue((dtor.getParent() == this.typeId ? 1 : 0) != 0);
            CPPASTArrayDeclarator adtor = new CPPASTArrayDeclarator(dtor.getName());
            IASTPointerOperator[] iASTPointerOperatorArray = ptrOps = dtor.getPointerOperators();
            int n = ptrOps.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator ptr = iASTPointerOperatorArray[n2];
                adtor.addPointerOperator(ptr);
                ++n2;
            }
            this.typeId.setAbstractDeclarator(adtor);
            dtor = adtor;
        }
        CPPASTArrayModifier mod = new CPPASTArrayModifier(expression);
        ((ASTNode)mod).setOffsetAndLength((ASTNode)((Object)expression));
        ((IASTArrayDeclarator)dtor).addArrayModifier(mod);
    }

    @Deprecated
    public IASTExpression getNewPlacement() {
        if (this.placement == null || this.placement.length == 0) {
            return null;
        }
        if (this.placement.length == 1) {
            if (this.placement[0] instanceof IASTExpression) {
                return (IASTExpression)this.placement[0];
            }
            return null;
        }
        CASTExpressionList result = new CASTExpressionList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.placement;
        int n = this.placement.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (arg instanceof IASTExpression) {
                result.addExpression(((IASTExpression)arg).copy());
            }
            ++n2;
        }
        result.setParent(this);
        result.setPropertyInParent(NEW_PLACEMENT);
        return result;
    }

    @Deprecated
    public void setNewPlacement(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setPlacementArguments(null);
        } else if (expression instanceof IASTExpressionList) {
            this.setPlacementArguments(((IASTExpressionList)expression).getExpressions());
        } else {
            this.setPlacementArguments(new IASTExpression[]{expression});
        }
    }

    @Deprecated
    public IASTExpression getNewInitializer() {
        if (this.initializer == null || this.initializer instanceof IASTExpression) {
            return (IASTExpression)((Object)this.initializer);
        }
        if (this.initializer instanceof ICPPASTConstructorInitializer) {
            IASTExpression expr = ((ICPPASTConstructorInitializer)this.initializer).getExpression();
            expr = expr == null ? new CPPASTExpressionList() : expr.copy();
            expr.setParent(this);
            expr.setPropertyInParent(NEW_INITIALIZER);
            return expr;
        }
        return null;
    }

    @Deprecated
    public void setNewInitializer(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setInitializer(null);
        } else if (expression instanceof IASTInitializer) {
            this.setInitializer((IASTInitializer)((Object)expression));
        } else {
            CPPASTConstructorInitializer ctorInit = new CPPASTConstructorInitializer();
            ctorInit.setExpression(expression);
            ctorInit.setOffsetAndLength((ASTNode)((Object)expression));
            this.setInitializer(ctorInit);
        }
    }
}

