/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTUsingDeclaration
extends ASTNode
implements ICPPASTUsingDeclaration,
ICPPASTCompletionContext {
    private boolean typeName;
    private IASTName name;

    public CPPASTUsingDeclaration() {
    }

    public CPPASTUsingDeclaration(IASTName name) {
        this.setName(name);
    }

    public CPPASTUsingDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTUsingDeclaration copy(IASTNode.CopyStyle style) {
        CPPASTUsingDeclaration copy = new CPPASTUsingDeclaration(this.name == null ? null : this.name.copy(style));
        copy.typeName = this.typeName;
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public void setIsTypename(boolean value) {
        this.assertNotFrozen();
        this.typeName = value;
    }

    public boolean isTypename() {
        return this.typeName;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 0;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding = iBindingArray[n3];
            if (binding instanceof ICPPNamespace) {
                filtered.add(binding);
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    public String toString() {
        return this.name.toString();
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

