/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model.xml;

import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorage;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorageElement;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;

public class InternalXmlStorageElement
extends XmlStorageElement {
    boolean fIsDirty;
    private boolean fIsReadOnly;
    XmlStorage fStorage;

    public InternalXmlStorageElement(Element element, ICStorageElement parent, String[] attributeFilters, String[] childFilters, boolean readOnly) {
        super(element, parent, attributeFilters, childFilters);
        this.fIsReadOnly = readOnly;
    }

    public InternalXmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent, boolean readOnly) {
        super(element, parent, alowReferencingParent);
        this.fIsReadOnly = readOnly;
    }

    public InternalXmlStorageElement(Element element, boolean readOnly) {
        super(element);
        this.fIsReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.setReadOnly(readOnly, true);
    }

    public void setReadOnly(boolean readOnly, boolean keepModify) {
        this.fIsReadOnly = readOnly;
        this.fIsDirty &= keepModify;
        ICStorageElement[] children = this.getChildren(false);
        int i = 0;
        while (i < children.length) {
            ((InternalXmlStorageElement)children[i]).setReadOnly(readOnly, keepModify);
            ++i;
        }
    }

    public boolean isModified() {
        if (this.fIsDirty) {
            return true;
        }
        if (this.fStorage != null && this.fStorage.isModified()) {
            return true;
        }
        ICStorageElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((InternalXmlStorageElement)children[i]).isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
        if (!dirty) {
            if (this.fStorage != null) {
                this.fStorage.setDirty(false);
            }
            ICStorageElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                ((InternalXmlStorageElement)children[i]).setDirty(false);
                ++i;
            }
        }
    }

    public void storageCreated(XmlStorage storage) {
        this.fStorage = storage;
    }

    public void clear() {
        this.makeModification();
        super.clear();
    }

    protected XmlStorageElement createChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        return new InternalXmlStorageElement(element, this, attributeFilters, childFilters, this.fIsReadOnly);
    }

    public ICStorageElement createChild(String name, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        this.makeModification();
        return super.createChild(name, alowReferencingParent, attributeFilters, childFilters);
    }

    public ICStorageElement createChild(String name) {
        this.makeModification();
        return super.createChild(name);
    }

    public void removeAttribute(String name) {
        this.makeModification();
        super.removeAttribute(name);
    }

    public void setAttribute(String name, String value) {
        this.makeModification();
        super.setAttribute(name, value);
    }

    public void setValue(String value) {
        this.makeModification();
        super.setValue(value);
    }

    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        this.makeModification();
        return super.importChild(el);
    }

    public void removeChild(ICStorageElement el) {
        this.makeModification();
        super.removeChild(el);
    }

    public ICSettingsStorage createSettingStorage(boolean readOnly) throws CoreException, UnsupportedOperationException {
        if (!this.isReadOnly() && readOnly) {
            return new XmlStorage(this.fElement, true);
        }
        return new XmlStorage(this);
    }

    private void makeModification() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsDirty = true;
    }
}

