/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class Exe {
    public static final String NL = System.getProperty("line.separator", "\n");
    protected RandomAccessFile rfile;
    ExeHeader ehdr;

    public ExeHeader getExeHeader() throws IOException {
        return this.ehdr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.rfile).append(NL);
        buffer.append(this.ehdr);
        return buffer.toString();
    }

    public Exe(String file) throws IOException {
        this.rfile = new RandomAccessFile(file, "r");
        try {
            this.ehdr = new ExeHeader(this.rfile);
        }
        finally {
            if (this.ehdr == null) {
                this.rfile.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Exe exe = new Exe(args[0]);
            System.out.println(exe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ExeHeader {
        public static final int EXEHDRSZ = 28;
        public byte[] e_signature = new byte[2];
        public short e_lastsize;
        public short e_nblocks;
        public short e_nreloc;
        public short e_hdrsize;
        public short e_minalloc;
        public short e_maxalloc;
        public short e_ss;
        public short e_sp;
        public short e_checksum;
        public short e_ip;
        public short e_cs;
        public short e_relocoffs;
        public short e_noverlay;

        protected ExeHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        protected ExeHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[28];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            this.commonSetup(memory);
        }

        public ExeHeader(byte[] hdr, boolean little) throws IOException {
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            this.commonSetup(memory);
        }

        public ExeHeader(ReadMemoryAccess memory) throws IOException {
            this.commonSetup(memory);
        }

        void commonSetup(ReadMemoryAccess memory) throws IOException {
            if (memory.getSize() < 28) {
                throw new IOException("Not DOS EXE format");
            }
            memory.getBytes(this.e_signature);
            if (this.e_signature[0] != 77 || this.e_signature[1] != 90) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notDOSFormat"));
            }
            this.e_lastsize = memory.getShort();
            this.e_nblocks = memory.getShort();
            this.e_nreloc = memory.getShort();
            this.e_hdrsize = memory.getShort();
            this.e_minalloc = memory.getShort();
            this.e_maxalloc = memory.getShort();
            this.e_ss = memory.getShort();
            this.e_sp = memory.getShort();
            this.e_checksum = memory.getShort();
            this.e_ip = memory.getShort();
            this.e_cs = memory.getShort();
            this.e_relocoffs = memory.getShort();
            this.e_noverlay = memory.getShort();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("EXE HEADER VALUES").append(NL);
            buffer.append("signature ");
            buffer.append(String.valueOf((char)this.e_signature[0]) + " " + (char)this.e_signature[1]);
            buffer.append(NL);
            buffer.append("lastsize: 0x");
            buffer.append(Long.toHexString(new Short(this.e_lastsize).longValue()));
            buffer.append(NL);
            buffer.append("nblocks: 0x");
            buffer.append(Long.toHexString(new Short(this.e_nblocks).longValue()));
            buffer.append(NL);
            buffer.append("nreloc: 0x");
            buffer.append(Long.toHexString(new Short(this.e_nreloc).longValue()));
            buffer.append(NL);
            buffer.append("hdrsize: 0x");
            buffer.append(Long.toHexString(new Short(this.e_hdrsize).longValue()));
            buffer.append(NL);
            buffer.append("minalloc: 0x");
            buffer.append(Long.toHexString(new Short(this.e_minalloc).longValue()));
            buffer.append(NL);
            buffer.append("maxalloc: 0x");
            buffer.append(Long.toHexString(new Short(this.e_maxalloc).longValue()));
            buffer.append(NL);
            buffer.append("ss: 0x");
            buffer.append(Long.toHexString(new Short(this.e_ss).longValue()));
            buffer.append(NL);
            buffer.append("sp: 0x");
            buffer.append(Long.toHexString(new Short(this.e_sp).longValue()));
            buffer.append(NL);
            buffer.append("checksum: 0x");
            buffer.append(Long.toHexString(new Short(this.e_checksum).longValue()));
            buffer.append(NL);
            buffer.append("ip: 0x");
            buffer.append(Long.toHexString(new Short(this.e_ip).longValue()));
            buffer.append(NL);
            buffer.append("cs: 0x");
            buffer.append(Long.toHexString(new Short(this.e_cs).longValue()));
            buffer.append(NL);
            buffer.append("relocoffs: 0x");
            buffer.append(Long.toHexString(new Short(this.e_relocoffs).longValue()));
            buffer.append(NL);
            buffer.append("overlay: 0x");
            buffer.append(Long.toHexString(new Short(this.e_noverlay).longValue()));
            buffer.append(NL);
            return buffer.toString();
        }
    }
}

