/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedRectangle
extends Shape {
    protected Dimension corner = new Dimension(8, 8);

    protected void fillShape(Graphics graphics) {
        graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
    }

    protected void outlineShape(Graphics graphics) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        graphics.drawRoundRectangle(r, Math.max(0, this.corner.width - (int)lineInset), Math.max(0, this.corner.height - (int)lineInset));
    }

    public void setCornerDimensions(Dimension d) {
        this.corner.width = d.width;
        this.corner.height = d.height;
    }

    public Dimension getCornerDimensions() {
        return this.corner.getCopy();
    }
}

